/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.vfs.gs.GoogleStorageFileSystem;
import org.apache.hop.vfs.gs.GoogleStorageFileSystemConfigBuilder;
import org.apache.hop.vfs.gs.config.GoogleCloudConfig;
import org.apache.hop.vfs.gs.config.GoogleCloudConfigSingleton;
import org.apache.hop.vfs.gs.metadatatype.GoogleStorageMetadataType;

public class GoogleStorageFileProvider
extends AbstractOriginatingFileProvider {
    private FileSystemOptions newFileSystemOptions = new FileSystemOptions();
    public static final Collection<Capability> capabilities = Set.of(Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT);

    public GoogleStorageFileProvider() {
        this.setServiceAccountCredentials(null, null);
    }

    public GoogleStorageFileProvider(IVariables variables, GoogleStorageMetadataType googleStorageMetadataType) {
        this.setServiceAccountCredentials(variables, googleStorageMetadataType);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new GoogleStorageFileSystem(rootName, null, this.newFileSystemOptions);
    }

    private void setServiceAccountCredentials(IVariables variables, GoogleStorageMetadataType googleStorageMetadataType) {
        block9: {
            try {
                GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
                String scheme = "gs";
                if (variables == null && googleStorageMetadataType == null) {
                    GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
                    if (!StringUtils.isEmpty((String)config.getServiceAccountKeyFile())) {
                        credentials = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(config.getServiceAccountKeyFile()));
                    }
                } else {
                    scheme = googleStorageMetadataType.getName();
                    switch (googleStorageMetadataType.getStorageCredentialsType()) {
                        case KEY_FILE: {
                            credentials = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(variables.resolve(googleStorageMetadataType.getStorageAccountKey())));
                            break;
                        }
                        case KEY_STRING: {
                            credentials = ServiceAccountCredentials.fromStream((InputStream)IOUtils.toInputStream((String)variables.resolve(googleStorageMetadataType.getStorageAccountKey()), (Charset)StandardCharsets.UTF_8));
                            break;
                        }
                    }
                }
                GoogleStorageFileSystemConfigBuilder.getInstance().setGoogleCredentials(this.newFileSystemOptions, credentials);
                GoogleStorageFileSystemConfigBuilder.getInstance().setSchema(this.newFileSystemOptions, scheme);
            }
            catch (Exception e) {
                if (googleStorageMetadataType == null) break block9;
                LogChannel.GENERAL.logError("Unable to set service account credentials for vfs name: " + googleStorageMetadataType.getName(), (Throwable)e);
            }
        }
    }
}

