/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaTimestamp;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampFn
extends DoFn<HopRow, HopRow> {
    private String transformName;
    private String rowMetaJson;
    private String fieldName;
    private final boolean getTimestamp;
    private transient Counter readCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;
    private transient int fieldIndex;
    private static final Logger LOG = LoggerFactory.getLogger(TimestampFn.class);
    private transient IRowMeta inputRowMeta;
    private transient IValueMeta fieldValueMeta;

    public TimestampFn(String transformName, String rowMetaJson, String fieldName, boolean getTimestamp) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.fieldName = fieldName;
        this.getTimestamp = getTimestamp;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            BeamHop.init();
            this.inputRowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.transformName);
            this.fieldIndex = -1;
            if (!this.getTimestamp && StringUtils.isNotEmpty((String)this.fieldName)) {
                this.fieldIndex = this.inputRowMeta.indexOfValue(this.fieldName);
                if (this.fieldIndex < 0) {
                    throw new RuntimeException("Field '" + this.fieldName + "' couldn't be found in put : " + this.inputRowMeta.toString());
                }
                this.fieldValueMeta = this.inputRowMeta.getValueMeta(this.fieldIndex);
            }
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error in setup of adding timestamp to rows : " + e.getMessage());
            throw new RuntimeException("Error setup of adding timestamp to rows", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            Instant instant;
            HopRow hopRow = (HopRow)processContext.element();
            this.readCounter.inc();
            if (this.getTimestamp) {
                instant = processContext.timestamp();
                Object[] outputRow = RowDataUtil.createResizedCopy((Object[])hopRow.getRow(), (int)(this.inputRowMeta.size() + 1));
                outputRow[this.inputRowMeta.size()] = instant.toDate();
                hopRow = new HopRow(outputRow);
            } else if (this.fieldIndex < 0) {
                instant = Instant.now();
            } else {
                Object fieldData = hopRow.getRow()[this.fieldIndex];
                if (9 == this.fieldValueMeta.getType()) {
                    Timestamp timestamp = ((ValueMetaTimestamp)this.fieldValueMeta).getTimestamp(fieldData);
                    instant = new Instant((Object)timestamp.toInstant());
                } else {
                    Date date = this.fieldValueMeta.getDate(fieldData);
                    if (date == null) {
                        throw new HopException("Timestamp field contains a null value, this can't be used to set a timestamp on a bounded/unbounded collection of data");
                    }
                    instant = new Instant(date.getTime());
                }
            }
            processContext.outputWithTimestamp((Object)hopRow, instant);
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error adding timestamp to rows : " + String.valueOf(processContext.element()) + ", " + e.getMessage());
            throw new RuntimeException("Error adding timestamp to rows", e);
        }
    }

    public Duration getAllowedTimestampSkew() {
        return Duration.standardMinutes((long)120L);
    }
}

