/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class CollectionSelector
implements Selector {
    private final Iterable<Selector> elementSelectors;
    private final String opening;
    private final String closing;
    private final CqlIdentifier alias;

    protected CollectionSelector(@NonNull Iterable<Selector> elementSelectors, @NonNull String opening, @NonNull String closing, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(elementSelectors);
        Preconditions.checkArgument((boolean)elementSelectors.iterator().hasNext(), (Object)"Must have at least one selector");
        CollectionSelector.checkNoAlias(elementSelectors);
        Preconditions.checkNotNull((Object)opening);
        Preconditions.checkNotNull((Object)closing);
        this.elementSelectors = elementSelectors;
        this.opening = opening;
        this.closing = closing;
        this.alias = alias;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        CqlHelper.append(this.elementSelectors, builder, this.opening, ",", this.closing);
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Iterable<Selector> getElementSelectors() {
        return this.elementSelectors;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CollectionSelector) {
            CollectionSelector that = (CollectionSelector)other;
            return Iterables.elementsEqual(this.elementSelectors, that.elementSelectors) && this.opening.equals(that.opening) && this.closing.equals(that.closing) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.elementSelectors, this.opening, this.closing, this.alias);
    }

    private static void checkNoAlias(Iterable<Selector> elementSelectors) {
        String offendingAliases = null;
        for (Selector selector : elementSelectors) {
            CqlIdentifier alias = selector.getAlias();
            if (alias == null) continue;
            if (offendingAliases == null) {
                offendingAliases = alias.asCql(true);
                continue;
            }
            offendingAliases = offendingAliases + ", " + alias.asCql(true);
        }
        if (offendingAliases != null) {
            throw new IllegalArgumentException("Can't use aliases in selection list, offending aliases: " + offendingAliases);
        }
    }
}

