/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import com.ibm.as400.micro.ResourceBundleLoader_m;
import com.ibm.as400.micro.Service;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class MEServer
implements Runnable {
    private static final String ME_CONNECTION_ACCEPTED_ = ResourceBundleLoader_m.getText("ME_CONNECTION_ACCEPTED");
    private Socket socket_;
    private MicroDataInputStream input_;
    private MicroDataOutputStream output_;
    private AS400 system_;
    private CommandCall cc_;
    private Connection connection_;
    private Service service_;
    private static final int DATASTREAM_LEVEL = 0;
    private static PrintStream verbose_ = System.out;
    private static boolean verboseState_ = false;
    private static final Hashtable registeredDocuments_ = new Hashtable();
    private static int port_;
    private static int threadIndex_;
    private static final Vector expectedOptions_;
    private static final Hashtable shortcuts_;
    private int nextTransactionID_ = 0;
    private Hashtable cachedJDBCTransactions_ = new Hashtable();

    private MEServer(Socket s) throws IOException {
        this.socket_ = s;
        this.input_ = new MicroDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
        this.output_ = new MicroDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
    }

    private int cacheTransaction(ResultSet rs) {
        Integer key = this.nextTransactionID_++;
        this.cachedJDBCTransactions_.put(key, rs);
        return key;
    }

    static char[] byteArrayToCharArray(byte[] byteValue) {
        if (byteValue == null) {
            return null;
        }
        char[] charValue = new char[byteValue.length / 2];
        int inPos = 0;
        int outPos = 0;
        while (inPos < byteValue.length) {
            charValue[outPos++] = (char)(((byteValue[inPos++] & 0xFF) << 8) + (byteValue[inPos++] & 0xFF));
        }
        return charValue;
    }

    private void close() {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                try {
                                    if (this.connection_ != null) {
                                        this.connection_.close();
                                    }
                                }
                                catch (Exception e) {
                                    if (!Trace.isTraceErrorOn()) break block19;
                                    Trace.log(2, "Error closing MEServer SQL Connection.", (Throwable)e);
                                }
                            }
                            try {
                                if (this.system_ != null) {
                                    this.system_.disconnectAllServices();
                                    this.system_ = null;
                                }
                            }
                            catch (Exception e) {
                                if (!Trace.isTraceErrorOn()) break block20;
                                Trace.log(2, "Error disconnecting all services on MEServer.", (Throwable)e);
                            }
                        }
                        this.system_ = null;
                        try {
                            if (this.input_ != null) {
                                this.input_.in_.close();
                                this.input_ = null;
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.isTraceErrorOn()) break block21;
                            Trace.log(2, "Error closing MEServer input stream.", (Throwable)e);
                        }
                    }
                    try {
                        if (this.output_ != null) {
                            this.output_.out_.close();
                            this.output_ = null;
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block22;
                        Trace.log(2, "Error closing MEServer output stream.", (Throwable)e);
                    }
                }
                try {
                    if (this.socket_ != null) {
                        this.socket_.close();
                        this.socket_ = null;
                        if (verboseState_) {
                            verbose_.println(ResourceBundleLoader_m.getText("ME_CONNECTION_CLOSED", Thread.currentThread().getName()));
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTraceErrorOn()) break block23;
                    Trace.log(2, "Error closing MEServer socket.", (Throwable)e);
                }
            }
            try {
                Enumeration e = this.cachedJDBCTransactions_.keys();
                while (e.hasMoreElements()) {
                    ((AS400JDBCResultSet)this.cachedJDBCTransactions_.get(e)).close();
                    this.cachedJDBCTransactions_.remove(e);
                }
            }
            catch (Exception e) {
                if (!Trace.isTraceErrorOn()) break block24;
                Trace.log(2, "Error closing SQL Result Set.", (Throwable)e);
            }
        }
    }

    private static byte[] decode(byte[] adder, byte[] mask, byte[] bytes) {
        int i;
        int length = bytes.length;
        byte[] buf = new byte[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(mask[i % mask.length] ^ bytes[i]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(buf[i] - adder[i % adder.length]);
        }
        return buf;
    }

    private void doCommandCall() throws ErrorCompletingRequestException, InterruptedException, IOException {
        String command = this.input_.readUTF();
        if (this.cc_ == null) {
            this.cc_ = new CommandCall(this.system_);
        }
        boolean retVal = false;
        try {
            retVal = this.cc_.run(command);
        }
        catch (PropertyVetoException pve) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "PropertyVetoException on run(command)", (Throwable)pve);
            }
        }
        catch (Exception e) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(e);
            return;
        }
        int numReplies = 0;
        AS400Message[] messages = this.cc_.getMessageList();
        if (!retVal) {
            numReplies = messages.length;
        }
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of messages returned from ToolboxME CommandCall: " + numReplies);
        }
        this.output_.writeInt(numReplies);
        this.output_.flush();
        for (int i = 0; i < numReplies; ++i) {
            this.output_.writeUTF(messages[i].getID() + ": " + messages[i].getText());
            if (!Trace.isTraceOn()) continue;
            Trace.log(1, messages[i].getText());
        }
        this.output_.flush();
    }

    private void doDataQueueRead() throws IOException, InterruptedException {
        String queueName = this.input_.readUTF();
        int dataType = this.input_.readInt();
        DataQueue dq = new DataQueue(this.system_, queueName);
        DataQueueEntry entry = null;
        try {
            entry = dq.read();
            this.output_.writeInt(4664);
        }
        catch (AS400SecurityException ase) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ase);
            return;
        }
        catch (ErrorCompletingRequestException ecr) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ecr);
            return;
        }
        catch (IOException ioe) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ioe);
            return;
        }
        catch (IllegalObjectTypeException iote) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(iote);
            return;
        }
        catch (ObjectDoesNotExistException odnee) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(odnee);
            return;
        }
        if (dataType == 4393) {
            this.output_.writeUTF(entry == null ? "" : entry.getString());
        } else if (dataType == 4392) {
            if (entry == null) {
                this.output_.writeInt(0);
            } else {
                byte[] b = entry.getData();
                this.output_.writeInt(b.length);
                this.output_.writeBytes(b);
            }
        }
        this.output_.flush();
    }

    private void doDataQueueWrite() throws IOException, InterruptedException {
        String queueName = this.input_.readUTF();
        int dataType = this.input_.readInt();
        DataQueue dq = new DataQueue(this.system_, queueName);
        try {
            if (dataType == 4392) {
                int len = this.input_.readInt();
                byte[] data = new byte[len];
                this.input_.readBytes(data);
                dq.write(data);
            } else if (dataType == 4393) {
                String data = this.input_.readUTF();
                dq.write(data);
            }
        }
        catch (ErrorCompletingRequestException ecr) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ecr);
            return;
        }
        catch (ExtendedIllegalArgumentException ecr) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ecr);
            return;
        }
        catch (AS400SecurityException ase) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ase);
            return;
        }
        catch (IOException ioe) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(ioe);
            return;
        }
        catch (IllegalObjectTypeException iote) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(iote);
            return;
        }
        catch (ObjectDoesNotExistException odnee) {
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(odnee);
            return;
        }
        this.output_.writeInt(4664);
        this.output_.flush();
    }

    private void doProgramCall() throws IOException, ErrorCompletingRequestException, InterruptedException {
        String pcmlName = this.input_.readUTF();
        String apiName = this.input_.readUTF();
        int numParmsToSet = this.input_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of PCML input Parms:" + numParmsToSet);
        }
        String[] tagNamesToSet = new String[numParmsToSet];
        String[] valuesToSet = new String[numParmsToSet];
        for (int i = 0; i < numParmsToSet; ++i) {
            tagNamesToSet[i] = this.input_.readUTF();
            valuesToSet[i] = this.input_.readUTF();
            if (!Trace.isTraceOn()) continue;
            Trace.log(6, "ToolboxME PCML input Parm[" + i + "] " + tagNamesToSet[i] + ": " + valuesToSet[i]);
        }
        int numParmsToGet = this.input_.readInt();
        String[] tagNamesToGet = new String[numParmsToGet];
        if (Trace.isTraceOn()) {
            Trace.log(6, "Number of PCML output Parms:" + numParmsToGet);
        }
        for (int i = 0; i < numParmsToGet; ++i) {
            tagNamesToGet[i] = this.input_.readUTF();
        }
        ProgramCallDocument pc = this.loadDocument(pcmlName);
        if (pc == null) {
            return;
        }
        this.output_.writeInt(4663);
        this.output_.flush();
        boolean retVal = false;
        try {
            pc.setSystem(this.system_);
            for (int i = 0; i < numParmsToSet; ++i) {
                pc.setStringValue(tagNamesToSet[i], valuesToSet[i], 0);
            }
            retVal = pc.callProgram(apiName);
            String[] values = null;
            if (retVal) {
                values = new String[numParmsToGet];
                for (int i = 0; i < numParmsToGet; ++i) {
                    values[i] = pc.getStringValue(tagNamesToGet[i], 0);
                    if (!Trace.isTraceOn()) continue;
                    Trace.log(6, "ToolboxME PCML ouput Parm[" + i + "] " + tagNamesToGet[i] + ": " + values[i]);
                }
            }
            this.output_.writeBoolean(retVal);
            this.output_.flush();
            if (!retVal) {
                AS400Message[] messages = pc.getMessageList(apiName);
                if (Trace.isTraceOn()) {
                    for (int j = 0; j < messages.length; ++j) {
                        Trace.log(2, messages[j].getText());
                    }
                }
                this.output_.writeInt(38);
                this.output_.writeUTF(messages[0].getID() + ": " + messages[0].getText());
                this.output_.flush();
            } else {
                for (int j = 0; j < numParmsToGet; ++j) {
                    this.output_.writeUTF(values[j] == null ? "" : values[j]);
                    this.output_.flush();
                }
            }
        }
        catch (PcmlException pe) {
            Exception e2 = pe.getException();
            if (e2 != null) {
                verbose_.println(e2.getMessage());
                this.output_.writeBoolean(false);
                this.sendException(e2);
            } else {
                if (verboseState_) {
                    verbose_.println(pe.getLocalizedMessage());
                }
                this.sendException(pe);
            }
            return;
        }
    }

    private static ProgramCallDocument getPCMLDocument(String pcml) throws PcmlException {
        ProgramCallDocument prog = (ProgramCallDocument)registeredDocuments_.get(pcml);
        if (prog != null) {
            if (verboseState_) {
                verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_CACHE", pcml));
            }
            return prog;
        }
        if (verboseState_) {
            verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_LOADING", pcml));
        }
        prog = new ProgramCallDocument();
        prog.setDocument(pcml);
        registeredDocuments_.put(pcml, prog);
        return prog;
    }

    private ProgramCallDocument loadDocument(String pcml) {
        try {
            return MEServer.getPCMLDocument(pcml);
        }
        catch (PcmlException pe) {
            block20: {
                verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                if (Trace.isTraceOn()) {
                    Trace.log(2, pe);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        this.output_.writeInt(37);
                        this.output_.writeUTF(pe.getLocalizedMessage());
                        this.output_.flush();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block20;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)e);
                    }
                }
            }
            return null;
        }
        catch (NoClassDefFoundError n) {
            block21: {
                if (pcml == null) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                }
                if (Trace.isTraceOn()) {
                    Trace.log(2, n);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        this.output_.writeInt(37);
                        this.output_.writeUTF(n.getClass().getName() + ": " + n.getMessage());
                        this.output_.flush();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block21;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)e);
                    }
                }
            }
            return null;
        }
        catch (MissingResourceException mre) {
            block22: {
                if (pcml == null) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                }
                if (Trace.isTraceOn()) {
                    Trace.log(2, mre);
                }
                if (this.output_ != null) {
                    try {
                        this.output_.writeInt(4665);
                        if (pcml.length() == 0) {
                            this.output_.writeInt(16);
                        } else {
                            this.output_.writeInt(37);
                        }
                        this.output_.writeUTF(mre.getClass().getName() + ": " + mre.getMessage());
                        this.output_.flush();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block22;
                        Trace.log(2, "Error returning exception, from PCML load, to ME client.", (Throwable)e);
                    }
                }
            }
            return null;
        }
    }

    public static void main(String[] args) {
        block7: {
            try {
                if (MEServer.parseArgs(args)) {
                    ServerSocket ss = new ServerSocket(port_);
                    verbose_.println(ResourceBundleLoader_m.getText("ME_SERVER_STARTED"));
                    if (verboseState_) {
                        verbose_.println(ResourceBundleLoader_m.getText("ME_SERVER_LISTENING", ResourceBundleLoader_m.getText("ME_SERVER_CONTAINER"), Integer.toString(port_)));
                    }
                    while (true) {
                        Socket s = ss.accept();
                        MEServer server = new MEServer(s);
                        Thread t = new Thread((Runnable)server, "ToolboxMEThread-" + threadIndex_++);
                        t.setDaemon(true);
                        t.start();
                        if (!verboseState_) continue;
                        verbose_.println(ResourceBundleLoader_m.substitute(ME_CONNECTION_ACCEPTED_, new Object[]{"MEServer", s.getInetAddress().toString(), t.getName()}));
                    }
                }
                MEServer.usage(System.out);
            }
            catch (BindException e) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Error opening ToolboxME server socket.", (Throwable)e);
                }
                verbose_.println(ResourceBundleLoader_m.getText("ME_ALREADY_LISTENING", Integer.toString(port_)));
            }
            catch (IOException e) {
                if (!Trace.isTraceErrorOn()) break block7;
                Trace.log(2, "Error opening ToolboxME server socket.", (Throwable)e);
            }
        }
    }

    static byte[] nextBytes(Random r, int numBytes) {
        byte[] buf = new byte[numBytes];
        long feeder = r.nextLong();
        int feederIndex = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (feederIndex > 7) {
                feeder = r.nextLong();
                feederIndex = 0;
            }
            buf[i] = (byte)(0xFFL & feeder >> 8 * feederIndex++);
        }
        return buf;
    }

    private static boolean parseArgs(String[] args) {
        CommandLineArguments cla = new CommandLineArguments(args, expectedOptions_, shortcuts_);
        if (cla.getOptionValue("-help") != null) {
            return false;
        }
        String optionValue = cla.getOptionValue("-verbose");
        if (optionValue != null) {
            if (optionValue.length() == 0 || optionValue.equalsIgnoreCase("true")) {
                verboseState_ = true;
            } else if (optionValue.equalsIgnoreCase("false")) {
                verboseState_ = false;
            } else {
                throw new IllegalArgumentException(ResourceBundleLoader_m.getText("ME_OPTION_VALUE_NOT_VALID", new String[]{"verbose", optionValue}));
            }
        }
        if ((optionValue = cla.getOptionValue("-pcml")) != null) {
            StringTokenizer msc = new StringTokenizer(optionValue, ";");
            while (msc.hasMoreTokens()) {
                try {
                    MEServer.getPCMLDocument(msc.nextToken());
                }
                catch (PcmlException pe) {
                    verbose_.println(ResourceBundleLoader_m.getText("ME_PCML_ERROR"));
                    if (verboseState_) {
                        verbose_.println(pe.getMessage());
                    }
                    if (!Trace.isTraceOn()) continue;
                    Trace.log(2, pe);
                }
            }
        }
        if ((optionValue = cla.getOptionValue("-port")) != null) {
            if (optionValue.length() > 0) {
                port_ = Integer.parseInt(optionValue);
            }
        } else {
            port_ = 3470;
        }
        Enumeration options = cla.getExtraOptions();
        while (options.hasMoreElements()) {
            String extraOption = options.nextElement().toString();
            verbose_.println(ResourceBundleLoader_m.getText("ME_OPTION_NOT_VALID", extraOption));
        }
        return true;
    }

    private static String resolve(byte[] info) {
        byte[] adder = new byte[18];
        System.arraycopy(info, 0, adder, 0, 18);
        byte[] mask = new byte[14];
        System.arraycopy(info, 18, mask, 0, 14);
        byte[] infoBytes = new byte[info.length - 32];
        System.arraycopy(info, 32, infoBytes, 0, info.length - 32);
        return new String(MEServer.byteArrayToCharArray(MEServer.decode(adder, mask, infoBytes)));
    }

    @Override
    public void run() {
        boolean jdbc = false;
        try {
            boolean disconnected = false;
            block14: while (!disconnected & !jdbc) {
                int cmd = this.input_.readInt();
                if (Trace.isTraceOn()) {
                    Trace.log(6, "ME Datastream Request: " + Integer.toHexString(cmd));
                }
                switch (cmd) {
                    case 4386: {
                        this.signon();
                        break;
                    }
                    case 4387: {
                        this.doCommandCall();
                        break;
                    }
                    case 4388: {
                        this.doProgramCall();
                        break;
                    }
                    case 4390: {
                        this.doDataQueueRead();
                        break;
                    }
                    case 4391: {
                        this.doDataQueueWrite();
                        break;
                    }
                    case 4688: 
                    case 4689: 
                    case 4690: 
                    case 4691: 
                    case 4692: 
                    case 4693: 
                    case 4694: 
                    case 4695: 
                    case 4696: 
                    case 4705: 
                    case 4706: 
                    case 4707: 
                    case 4708: 
                    case 4721: 
                    case 4737: 
                    case 4738: 
                    case 4739: 
                    case 4740: 
                    case 4741: 
                    case 4742: 
                    case 4743: 
                    case 4744: 
                    case 4745: 
                    case 4752: 
                    case 4753: 
                    case 4754: 
                    case 4755: 
                    case 4756: 
                    case 4757: 
                    case 4758: {
                        if (this.service_ == null) {
                            this.service_ = new JdbcMeService();
                        }
                        this.service_.setDataStreams(this.input_, this.output_);
                        try {
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Trying service com.ibm.as400.micro.JdbcMeService for Function id " + Integer.toHexString(cmd));
                            }
                            if (this.service_.acceptsRequest(cmd)) break;
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Servicing function id " + Integer.toHexString(cmd));
                            }
                            this.service_.handleRequest(cmd);
                            if (Trace.isTraceOn()) {
                                Trace.log(6, "Service complete");
                            }
                            this.output_.flush();
                        }
                        catch (EOFException eof) {
                            if (!Trace.isTraceOn()) continue block14;
                            Trace.log(2, "EOF: Client disconnected", (Throwable)eof);
                        }
                        catch (IOException ioe) {
                            if (!Trace.isTraceOn()) continue block14;
                            Trace.log(2, "IOException detected - finally block handles cleanup.", (Throwable)ioe);
                        }
                        break;
                    }
                    case 4389: {
                        if (Trace.isTraceOn()) {
                            Trace.log(6, "ToolboxME disconnect received.");
                        }
                        this.close();
                        disconnected = true;
                        break;
                    }
                    default: {
                        this.output_.writeInt(4665);
                        this.output_.writeInt(4672);
                        this.output_.writeUTF("ToolboxME Request not supported: " + Integer.toHexString(cmd));
                        this.output_.flush();
                    }
                }
            }
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, e);
            }
            this.stop(e.getMessage());
        }
        this.close();
    }

    private void signon() throws IOException {
        int clientDataStreamLevel = this.input_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, "Micro client datastream level: " + clientDataStreamLevel);
        }
        byte[] proxySeed = new byte[18];
        this.input_.readBytes(proxySeed);
        this.output_.writeInt(0);
        byte[] remoteSeed = MEServer.nextBytes(new Random(), 14);
        this.output_.writeBytes(remoteSeed);
        this.output_.flush();
        String serverName = this.input_.readUTF();
        String userid = this.input_.readUTF();
        int numBytes = this.input_.readInt();
        byte[] bytes = new byte[numBytes];
        this.input_.readBytes(bytes);
        if (this.system_ != null) {
            this.system_.disconnectAllServices();
        }
        boolean retVal = false;
        try {
            this.system_ = new AS400(serverName, userid, MEServer.resolve(MEServer.decode(proxySeed, remoteSeed, bytes)));
            this.system_.setLocale(Locale.US);
            retVal = this.system_.validateSignon();
        }
        catch (Exception e) {
            this.system_ = null;
            this.output_.writeInt(4665);
            this.output_.flush();
            this.sendException(e);
            return;
        }
        int retCode = 4660;
        if (!retVal) {
            this.system_ = null;
            retCode = 4661;
        }
        this.output_.writeInt(retCode);
        this.output_.flush();
    }

    private final void stop(String failure) {
        block5: {
            block4: {
                try {
                    this.output_.writeInt(4665);
                    this.output_.writeUTF(failure);
                }
                catch (Exception e) {
                    if (!Trace.isTraceErrorOn()) break block4;
                    Trace.log(2, "Error returning exception, during stop, to ME client.", (Throwable)e);
                }
            }
            try {
                this.output_.flush();
            }
            catch (Exception e) {
                if (!Trace.isTraceErrorOn()) break block5;
                Trace.log(2, "Error flushing output stream during MEServer stop.", (Throwable)e);
            }
        }
        this.close();
    }

    private void sendException(Exception e) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "ME Exception Occurred: \n", (Throwable)e);
        }
        if (e instanceof AS400SecurityException) {
            int rc = ((AS400SecurityException)e).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + rc);
            }
            switch (rc) {
                case 6: {
                    this.output_.writeInt(2);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                case 7: {
                    this.output_.writeInt(3);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                case 8: {
                    this.output_.writeInt(4);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                case 30: {
                    this.output_.writeInt(5);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                case 31: {
                    this.output_.writeInt(6);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                case 32: {
                    this.output_.writeInt(7);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
                default: {
                    this.output_.writeInt(1);
                    this.output_.writeUTF(e.getMessage());
                    break;
                }
            }
        } else if (e instanceof PcmlException) {
            this.output_.writeBoolean(false);
            this.output_.writeInt(40);
            this.output_.writeUTF(e.getLocalizedMessage());
        } else if (e instanceof ObjectDoesNotExistException) {
            this.output_.writeInt(9);
            this.output_.writeUTF(e.getMessage());
        } else if (e instanceof ExtendedIllegalArgumentException) {
            int rc = ((ExtendedIllegalArgumentException)e).getReturnCode();
            if (rc == 1) {
                this.output_.writeInt(18);
            } else {
                this.output_.writeInt(16);
            }
            this.output_.writeUTF(e.getMessage());
        } else if (e instanceof ExtendedIllegalStateException) {
            this.output_.writeInt(17);
            this.output_.writeUTF(e.getMessage());
        } else if (e instanceof ErrorCompletingRequestException) {
            int rc = ((ErrorCompletingRequestException)e).getReturnCode();
            if (rc == 9) {
                this.output_.writeInt(18);
            } else {
                this.output_.writeInt(53);
            }
            this.output_.writeUTF(e.getMessage());
        } else if (e instanceof ConnectionDroppedException) {
            int rc = ((ConnectionDroppedException)e).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + rc);
            }
            if (rc == 2) {
                this.output_.writeInt(32);
                this.output_.writeUTF(e.getMessage());
            } else {
                this.output_.writeInt(53);
                this.output_.writeUTF(e.getMessage());
            }
        } else if (e instanceof IllegalObjectTypeException) {
            this.output_.writeInt(39);
            this.output_.writeUTF(e.getMessage());
        } else if (e instanceof ServerStartupException) {
            int rc = ((ServerStartupException)e).getReturnCode();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception return code: " + rc);
            }
            if (rc == 3) {
                this.output_.writeInt(33);
                this.output_.writeUTF(e.getMessage());
            } else {
                this.output_.writeInt(53);
                this.output_.writeUTF(e.getMessage());
            }
        } else if (e instanceof UnknownHostException) {
            this.output_.writeInt(34);
            this.output_.writeUTF(e.toString());
        } else if (e instanceof IOException) {
            this.output_.writeInt(53);
            this.output_.writeUTF(e.toString());
        } else {
            this.output_.writeInt(53);
            this.output_.writeUTF(e.getMessage());
        }
        this.output_.flush();
    }

    static void usage(PrintStream out) {
        String usage = ResourceBundleLoader_m.getText("ME_SERVER_USAGE");
        String optionslc = ResourceBundleLoader_m.getText("ME_SERVER_OPTIONSLC");
        String optionsuc = ResourceBundleLoader_m.getText("ME_SERVER_OPTIONSUC");
        String shortcuts = ResourceBundleLoader_m.getText("ME_SERVER_SHORTCUTS");
        out.println(usage + ":");
        out.println();
        out.println("  com.ibm.as400.access.MEServer [ " + optionslc + " ]");
        out.println();
        out.println(optionsuc + ":");
        out.println();
        out.println("  -pcml     [pcml doc]");
        out.println("  -port     port");
        out.println("  -verbose  [true | false]");
        out.println("  -help");
        out.println();
        out.println(shortcuts + ":");
        out.println("  -v   [true | false]");
        out.println("  -pc  pcml doc1 [;pcml doc2;...]");
        out.println("  -po  port");
        out.println("  -h");
        out.println("  -?");
    }

    static {
        threadIndex_ = 0;
        expectedOptions_ = new Vector();
        shortcuts_ = new Hashtable();
        expectedOptions_.addElement("-port");
        expectedOptions_.addElement("-pcml");
        expectedOptions_.addElement("-verbose");
        expectedOptions_.addElement("-help");
        shortcuts_.put("-po", "-port");
        shortcuts_.put("-pc", "-pcml");
        shortcuts_.put("-v", "-verbose");
        shortcuts_.put("-h", "-help");
        shortcuts_.put("-?", "-help");
    }
}

