/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.util.Preconditions;

public class BufferSizeEMA {
    private final int maxBufferSize;
    private final int minBufferSize;
    private final double alpha;
    private int lastBufferSize;

    public BufferSizeEMA(int maxBufferSize, int minBufferSize, long numberOfSamples) {
        this.maxBufferSize = maxBufferSize;
        this.minBufferSize = minBufferSize;
        this.alpha = 2.0 / (double)(numberOfSamples + 1L);
        this.lastBufferSize = maxBufferSize;
    }

    public int calculateBufferSize(long totalBufferSizeInBytes, int totalBuffers) {
        Preconditions.checkArgument((totalBufferSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"Size of buffer should be non negative");
        Preconditions.checkArgument((totalBuffers > 0 ? 1 : 0) != 0, (Object)"Number of buffers should be positive");
        long desirableBufferSize = Math.min(totalBufferSizeInBytes / (long)totalBuffers, 2L * (long)this.lastBufferSize);
        this.lastBufferSize = (int)((double)this.lastBufferSize + this.alpha * (double)(desirableBufferSize - (long)this.lastBufferSize));
        this.lastBufferSize = Math.max(this.minBufferSize, Math.min(this.lastBufferSize, this.maxBufferSize));
        return this.lastBufferSize;
    }
}

