/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.net.Capture;

public class CaptureIndex {
    private final NavigableSet<Capture> entries = new TreeSet<Capture>(Comparator.comparing(Capture::uriKey).thenComparing(Capture::date));
    private Capture entrypoint;

    public CaptureIndex(List<Path> warcs) throws IOException {
        for (Path warc : warcs) {
            WarcReader reader = new WarcReader(warc);
            Throwable throwable = null;
            try {
                for (WarcRecord record : reader) {
                    WarcCaptureRecord capture;
                    String scheme;
                    if (!(record instanceof WarcResponse) && !(record instanceof WarcResource) || !"http".equalsIgnoreCase(scheme = (capture = (WarcCaptureRecord)record).targetURI().getScheme()) && !"https".equalsIgnoreCase(scheme)) continue;
                    Capture entry = new Capture(capture.targetURI(), capture.date(), warc, reader.position());
                    this.add(entry);
                    if (this.entrypoint != null || !MediaType.HTML.equals(capture.payloadType().base())) continue;
                    this.entrypoint = entry;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    void add(Capture capture) {
        this.entries.add(capture);
    }

    NavigableSet<Capture> query(URI uri) {
        return this.entries.subSet(new Capture(uri, Instant.MIN), true, new Capture(uri, Instant.MAX), true);
    }

    Capture entrypoint() {
        return this.entrypoint;
    }
}

