/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkNodeList;

public class CompositeLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    private LeftTupleSinkNodeList sinks;
    private volatile LeftTupleSink[] sinkArray;

    public CompositeLeftTupleSinkAdapter() {
        super(RuleBasePartitionId.MAIN_PARTITION);
    }

    public CompositeLeftTupleSinkAdapter(RuleBasePartitionId partitionId) {
        super(partitionId);
        this.sinks = new LeftTupleSinkNodeList();
    }

    public void addTupleSink(LeftTupleSink sink) {
        this.sinks.add((LeftTupleSinkNode)sink);
        this.sinkArray = null;
    }

    public void removeTupleSink(LeftTupleSink sink) {
        this.sinks.remove((LeftTupleSinkNode)sink);
        this.sinkArray = null;
    }

    public LeftTupleSinkNodeList getRawSinks() {
        return this.sinks;
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!candidate.equals(sink)) continue;
            return (BaseNode)((Object)sink);
        }
        return null;
    }

    @Override
    public LeftTupleSink[] getSinks() {
        if (this.sinkArray != null) {
            return this.sinkArray;
        }
        LeftTupleSink[] sinks = new LeftTupleSink[this.sinks.size()];
        int i = 0;
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            sinks[i++] = sink;
        }
        this.sinkArray = sinks;
        return sinks;
    }

    @Override
    public LeftTupleSinkNode getFirstLeftTupleSink() {
        return this.sinks.getFirst();
    }

    @Override
    public LeftTupleSinkNode getLastLeftTupleSink() {
        return this.sinks.getLast();
    }

    @Override
    public int size() {
        return this.sinks.size();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sinks = (LeftTupleSinkNodeList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sinks);
    }
}

