/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async.xp;

import java.util.Map;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.workflow.WorkflowPainterExtension;

@ExtensionPoint(id="DrawAsyncLoggingIconExtensionPoint", description="Draw the logging icon next to an action which has debug level information stored", extensionPointId="WorkflowPainterAction")
public class DrawAsyncLoggingIconExtensionPoint
implements IExtensionPoint<WorkflowPainterExtension> {
    public static final String STRING_AREA_OWNER_PREFIX = "Report pipeline async stats to service ";

    public void callExtensionPoint(ILogChannel log, IVariables variables, WorkflowPainterExtension ext) {
        if (!ext.actionMeta.isPipeline()) {
            return;
        }
        try {
            Map pipelineMap = (Map)ext.actionMeta.getAttributesMap().get("ASYNC_STATUS_GROUP");
            if (pipelineMap == null) {
                return;
            }
            String serviceName = (String)pipelineMap.get("enable-asynchronous-pipeline-service-name");
            if (serviceName == null) {
                return;
            }
            Rectangle r = this.drawLogIcon(ext.gc, ext.x1, ext.y1, ext.iconSize, this.getClass().getClassLoader());
            ext.areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, r.x, r.y, r.width, r.height, ext.offset, (Object)ext.actionMeta, (Object)(STRING_AREA_OWNER_PREFIX + serviceName)));
        }
        catch (Exception e) {
            log.logError("Error drawing async log icon", (Throwable)e);
        }
    }

    public Rectangle drawLogIcon(IGc gc, int x, int y, int iconSize, ClassLoader classLoader) throws Exception {
        int imageWidth = 16;
        int imageHeight = 16;
        int locationX = x + iconSize;
        int locationY = y + iconSize - imageHeight - 5;
        gc.drawImage(new SvgFile("ui/images/log.svg", classLoader), locationX, locationY, imageWidth, imageHeight, gc.getMagnification(), 0.0);
        return new Rectangle(locationX, locationY, imageWidth, imageHeight);
    }
}

