/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthorizedViewName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_TABLE_AUTHORIZED_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String table;
    private final String authorizedView;

    @Deprecated
    protected AuthorizedViewName() {
        this.project = null;
        this.instance = null;
        this.table = null;
        this.authorizedView = null;
    }

    private AuthorizedViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
        this.authorizedView = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedView());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getTable() {
        return this.table;
    }

    public String getAuthorizedView() {
        return this.authorizedView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AuthorizedViewName of(String project, String instance, String table, String authorizedView) {
        return AuthorizedViewName.newBuilder().setProject(project).setInstance(instance).setTable(table).setAuthorizedView(authorizedView).build();
    }

    public static String format(String project, String instance, String table, String authorizedView) {
        return AuthorizedViewName.newBuilder().setProject(project).setInstance(instance).setTable(table).setAuthorizedView(authorizedView).build().toString();
    }

    public static AuthorizedViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_TABLE_AUTHORIZED_VIEW.validatedMatch(formattedString, "AuthorizedViewName.parse: formattedString not in valid format");
        return AuthorizedViewName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("table"), (String)matchMap.get("authorized_view"));
    }

    public static List<AuthorizedViewName> parseList(List<String> formattedStrings) {
        ArrayList<AuthorizedViewName> list = new ArrayList<AuthorizedViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AuthorizedViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AuthorizedViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AuthorizedViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_TABLE_AUTHORIZED_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AuthorizedViewName authorizedViewName = this;
            synchronized (authorizedViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.table != null) {
                        fieldMapBuilder.put((Object)"table", (Object)this.table);
                    }
                    if (this.authorizedView != null) {
                        fieldMapBuilder.put((Object)"authorized_view", (Object)this.authorizedView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_TABLE_AUTHORIZED_VIEW.instantiate(new String[]{"project", this.project, "instance", this.instance, "table", this.table, "authorized_view", this.authorizedView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AuthorizedViewName that = (AuthorizedViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.table, that.table) && Objects.equals(this.authorizedView, that.authorizedView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.table);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authorizedView);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String table;
        private String authorizedView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getTable() {
            return this.table;
        }

        public String getAuthorizedView() {
            return this.authorizedView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setAuthorizedView(String authorizedView) {
            this.authorizedView = authorizedView;
            return this;
        }

        private Builder(AuthorizedViewName authorizedViewName) {
            this.project = authorizedViewName.project;
            this.instance = authorizedViewName.instance;
            this.table = authorizedViewName.table;
            this.authorizedView = authorizedViewName.authorizedView;
        }

        public AuthorizedViewName build() {
            return new AuthorizedViewName(this);
        }
    }
}

