/*
 * Decompiled with CFR 0.152.
 */
package com.mifmif.common.regex;

import com.mifmif.common.regex.GenerexIterator;
import com.mifmif.common.regex.Node;
import com.mifmif.common.regex.util.Iterable;
import com.mifmif.common.regex.util.Iterator;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generex
implements Iterable {
    private static final Map<String, String> PREDEFINED_CHARACTER_CLASSES;
    private RegExp regExp;
    private Automaton automaton;
    private List<String> matchedStrings = new ArrayList<String>();
    private Node rootNode;
    private boolean isTransactionNodeBuilt;
    private int matchedStringCounter = 0;
    private int preparedTransactionNode;
    private Random random;

    public Generex(String regex) {
        this(regex, new Random());
    }

    public Generex(Automaton automaton) {
        this(automaton, new Random());
    }

    public Generex(String regex, Random random) {
        regex = Generex.requote(regex);
        this.regExp = Generex.createRegExp(regex);
        this.automaton = this.regExp.toAutomaton();
        this.random = random;
    }

    public Generex(Automaton automaton, Random random) {
        this.automaton = automaton;
        this.random = random;
    }

    private static RegExp createRegExp(String regex) {
        String finalRegex = regex;
        for (Map.Entry<String, String> charClass : PREDEFINED_CHARACTER_CLASSES.entrySet()) {
            finalRegex = finalRegex.replaceAll(charClass.getKey(), charClass.getValue());
        }
        return new RegExp(finalRegex);
    }

    public void setSeed(long seed) {
        this.random = new Random(seed);
    }

    public String getMatchedString(int indexOrder) {
        this.buildRootNode();
        if (indexOrder == 0) {
            indexOrder = 1;
        }
        String result = this.buildStringFromNode(this.rootNode, indexOrder);
        result = result.substring(1, result.length() - 1);
        return result;
    }

    private String buildStringFromNode(Node node, int indexOrder) {
        String result = "";
        long passedStringNbr = 0L;
        long step = node.getNbrMatchedString() / (long)node.getNbrChar();
        for (char usedChar = node.getMinChar(); usedChar <= node.getMaxChar(); usedChar = (char)(usedChar + '\u0001')) {
            if ((passedStringNbr += step) < (long)indexOrder) continue;
            indexOrder = (int)((long)indexOrder - (passedStringNbr -= step));
            result = result.concat("" + usedChar);
            break;
        }
        long passedStringNbrInChildNode = 0L;
        if (result.length() == 0) {
            passedStringNbrInChildNode = passedStringNbr;
        }
        for (Node childN : node.getNextNodes()) {
            if ((passedStringNbrInChildNode += childN.getNbrMatchedString()) < (long)indexOrder) continue;
            indexOrder = (int)((long)indexOrder - (passedStringNbrInChildNode -= childN.getNbrMatchedString()));
            result = result.concat(this.buildStringFromNode(childN, indexOrder));
            break;
        }
        return result;
    }

    public boolean isInfinite() {
        return !this.automaton.isFinite();
    }

    public String getFirstMatch() {
        this.buildRootNode();
        Node node = this.rootNode;
        String result = "";
        while (node.getNextNodes().size() > 0) {
            result = result.concat("" + node.getMinChar());
            node = node.getNextNodes().get(0);
        }
        result = result.substring(1);
        return result;
    }

    public long matchedStringsSize() {
        this.buildRootNode();
        return this.rootNode.getNbrMatchedString();
    }

    private void buildRootNode() {
        if (this.isTransactionNodeBuilt) {
            return;
        }
        this.isTransactionNodeBuilt = true;
        this.rootNode = new Node();
        this.rootNode.setNbrChar(1);
        List<Node> nextNodes = this.prepareTransactionNodes(this.automaton.getInitialState());
        this.rootNode.setNextNodes(nextNodes);
        this.rootNode.updateNbrMatchedString();
    }

    private void generate(String strMatch, State state, int limit) {
        if (this.matchedStringCounter == limit) {
            return;
        }
        ++this.matchedStringCounter;
        List transitions = state.getSortedTransitions(true);
        if (transitions.size() == 0) {
            this.matchedStrings.add(strMatch);
            return;
        }
        if (state.isAccept()) {
            this.matchedStrings.add(strMatch);
        }
        for (Transition transition : transitions) {
            for (char c = transition.getMin(); c <= transition.getMax(); c = (char)(c + '\u0001')) {
                this.generate(strMatch + c, transition.getDest(), limit);
            }
        }
    }

    private List<Node> prepareTransactionNodes(State state) {
        ArrayList<Node> transactionNodes = new ArrayList<Node>();
        if (this.preparedTransactionNode == 0x3FFFFFFF) {
            return transactionNodes;
        }
        ++this.preparedTransactionNode;
        if (state.isAccept()) {
            Node acceptedNode = new Node();
            acceptedNode.setNbrChar(1);
            transactionNodes.add(acceptedNode);
        }
        List transitions = state.getSortedTransitions(true);
        for (Transition transition : transitions) {
            Node trsNode = new Node();
            int nbrChar = transition.getMax() - transition.getMin() + 1;
            trsNode.setNbrChar(nbrChar);
            trsNode.setMaxChar(transition.getMax());
            trsNode.setMinChar(transition.getMin());
            List<Node> nextNodes = this.prepareTransactionNodes(transition.getDest());
            trsNode.setNextNodes(nextNodes);
            transactionNodes.add(trsNode);
        }
        return transactionNodes;
    }

    public List<String> getAllMatchedStrings() {
        this.matchedStrings = new ArrayList<String>();
        this.generate("", this.automaton.getInitialState(), Integer.MAX_VALUE);
        return this.matchedStrings;
    }

    public List<String> getMatchedStrings(int limit) {
        this.matchedStrings = new ArrayList<String>();
        this.generate("", this.automaton.getInitialState(), limit);
        return this.matchedStrings;
    }

    public String random() {
        return this.prepareRandom("", this.automaton.getInitialState(), 1, Integer.MAX_VALUE);
    }

    public String random(int minLength) {
        return this.prepareRandom("", this.automaton.getInitialState(), minLength, Integer.MAX_VALUE);
    }

    public String random(int minLength, int maxLength) {
        return this.prepareRandom("", this.automaton.getInitialState(), minLength, maxLength);
    }

    private String prepareRandom(String strMatch, State state, int minLength, int maxLength) {
        List transitions = state.getSortedTransitions(false);
        HashSet<Integer> selectedTransitions = new HashSet<Integer>();
        String result = strMatch;
        while (transitions.size() > selectedTransitions.size()) {
            int diff;
            if (state.isAccept()) {
                if (strMatch.length() == maxLength) {
                    return strMatch;
                }
                if ((double)this.random.nextInt() > 6.442450941E8 && strMatch.length() >= minLength) {
                    return strMatch;
                }
            }
            if (transitions.size() == 0) {
                return strMatch;
            }
            int nextInt = this.random.nextInt(transitions.size());
            if (selectedTransitions.contains(nextInt)) continue;
            selectedTransitions.add(nextInt);
            Transition randomTransition = (Transition)transitions.get(nextInt);
            int randomOffset = diff = randomTransition.getMax() - randomTransition.getMin() + 1;
            if (diff > 0) {
                randomOffset = this.random.nextInt(diff);
            }
            char randomChar = (char)(randomOffset + randomTransition.getMin());
            result = this.prepareRandom(strMatch + randomChar, randomTransition.getDest(), minLength, maxLength);
            int resultLength = result.length();
            if (minLength > resultLength || resultLength > maxLength) continue;
            break;
        }
        return result;
    }

    @Override
    public Iterator iterator() {
        return new GenerexIterator(this.automaton.getInitialState());
    }

    public static boolean isValidPattern(String regex) {
        try {
            Generex.createRegExp(regex);
            return true;
        }
        catch (IllegalArgumentException ignore) {
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return false;
    }

    private static String requote(String regex) {
        Pattern patternRequoted = Pattern.compile("\\\\Q(.*?)\\\\E");
        Pattern patternSpecial = Pattern.compile("[.^$*+?(){|\\[\\\\@]");
        StringBuilder sb = new StringBuilder(regex);
        Matcher matcher = patternRequoted.matcher(sb);
        while (matcher.find()) {
            sb.replace(matcher.start(), matcher.end(), patternSpecial.matcher(matcher.group(1)).replaceAll("\\\\$0"));
        }
        return sb.toString();
    }

    static {
        HashMap<String, String> characterClasses = new HashMap<String, String>();
        characterClasses.put("\\\\d", "[0-9]");
        characterClasses.put("\\\\D", "[^0-9]");
        characterClasses.put("\\\\s", "[ \t\n\f\r]");
        characterClasses.put("\\\\S", "[^ \t\n\f\r]");
        characterClasses.put("\\\\w", "[a-zA-Z_0-9]");
        characterClasses.put("\\\\W", "[^a-zA-Z_0-9]");
        PREDEFINED_CHARACTER_CLASSES = Collections.unmodifiableMap(characterClasses);
    }
}

