/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class TypeCode
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -1935648338090036611L;
    private @UnknownKeyFor @NonNull @Initialized String code;

    private TypeCode() {
    }

    public TypeCode(@UnknownKeyFor @NonNull @Initialized String code) {
        this.code = code;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCode() {
        return this.code;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeCode)) {
            return false;
        }
        TypeCode typeCode = (TypeCode)o;
        return Objects.equals(this.code, typeCode.code);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.code);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "TypeCode{code='" + this.code + '\'' + '}';
    }
}

