/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import org.apache.beam.sdk.io.aws2.auth.WebIdTokenProvider;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.GoogleCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.IdTokenCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.IdTokenProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Initialization is safe.")
public class GoogleADCIdTokenProvider
implements WebIdTokenProvider {
    private final @UnknownKeyFor @NonNull @Initialized IdTokenProvider idTokenProvider;

    public GoogleADCIdTokenProvider() {
        try {
            this.idTokenProvider = (IdTokenProvider)GoogleCredentials.getApplicationDefault();
        }
        catch (IOException ex) {
            throw new RuntimeException("Problems while retrieving application default credentials.", ex);
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized IdTokenCredentials createIdTokenWithApplicationDefaultCredentials(@UnknownKeyFor @NonNull @Initialized String audience) {
        return IdTokenCredentials.newBuilder().setIdTokenProvider(this.idTokenProvider).setTargetAudience(audience).setOptions(Arrays.asList(IdTokenProvider.Option.FORMAT_FULL, IdTokenProvider.Option.LICENSES_TRUE)).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String resolveTokenValue(@UnknownKeyFor @NonNull @Initialized String audience) {
        try {
            return this.createIdTokenWithApplicationDefaultCredentials(audience).refreshAccessToken().getTokenValue();
        }
        catch (IOException ex) {
            throw new RuntimeException("Problems while refreshing the identification token.", ex);
        }
    }
}

