/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeJoinAssemblerFn
extends DoFn<KV<HopRow, KV<HopRow, HopRow>>, HopRow> {
    public static int JOIN_TYPE_INNER = 0;
    public static int JOIN_TYPE_LEFT_OUTER = 1;
    public static int JOIN_TYPE_RIGHT_OUTER = 2;
    public static int JOIN_TYPE_FULL_OUTER = 3;
    private int joinType;
    private String leftRowMetaJson;
    private String rightRowMetaJson;
    private String leftKRowMetaJson;
    private String leftVRowMetaJson;
    private String rightKRowMetaJson;
    private String rightVRowMetaJson;
    private String counterName;
    private static final Logger LOG = LoggerFactory.getLogger(MergeJoinAssemblerFn.class);
    private transient IRowMeta leftRowMeta;
    private transient IRowMeta rightRowMeta;
    private transient IRowMeta leftKRowMeta;
    private transient IRowMeta leftVRowMeta;
    private transient IRowMeta rightKRowMeta;
    private transient IRowMeta rightVRowMeta;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;
    private transient Map<Integer, Integer> leftKeyIndexes;
    private transient Map<Integer, Integer> leftValueIndexes;
    private transient Map<Integer, Integer> rightKeyIndexes;
    private transient Map<Integer, Integer> rightValueIndexes;

    public MergeJoinAssemblerFn() {
    }

    public MergeJoinAssemblerFn(int joinType, String leftRowMetaJson, String rightRowMetaJson, String leftKRowMetaJson, String leftVRowMetaJson, String rightKRowMetaJson, String rightVRowMetaJson, String counterName) {
        this.joinType = joinType;
        this.leftRowMetaJson = leftRowMetaJson;
        this.rightRowMetaJson = rightRowMetaJson;
        this.leftKRowMetaJson = leftKRowMetaJson;
        this.leftVRowMetaJson = leftVRowMetaJson;
        this.rightKRowMetaJson = rightKRowMetaJson;
        this.rightVRowMetaJson = rightVRowMetaJson;
        this.counterName = counterName;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            int index;
            IValueMeta valueMeta;
            int i;
            this.writtenCounter = Metrics.counter((String)"written", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init();
            this.leftRowMeta = JsonRowMeta.fromJson((String)this.leftRowMetaJson);
            this.rightRowMeta = JsonRowMeta.fromJson((String)this.rightRowMetaJson);
            this.leftKRowMeta = JsonRowMeta.fromJson((String)this.leftKRowMetaJson);
            this.leftVRowMeta = JsonRowMeta.fromJson((String)this.leftVRowMetaJson);
            this.rightKRowMeta = JsonRowMeta.fromJson((String)this.rightKRowMetaJson);
            this.rightVRowMeta = JsonRowMeta.fromJson((String)this.rightVRowMetaJson);
            this.leftKeyIndexes = new HashMap<Integer, Integer>();
            this.leftValueIndexes = new HashMap<Integer, Integer>();
            this.rightKeyIndexes = new HashMap<Integer, Integer>();
            this.rightValueIndexes = new HashMap<Integer, Integer>();
            for (i = 0; i < this.leftRowMeta.size(); ++i) {
                valueMeta = this.leftRowMeta.getValueMeta(i);
                index = this.leftKRowMeta.indexOfValue(valueMeta.getName());
                if (index >= 0) {
                    this.leftKeyIndexes.put(i, index);
                }
                if ((index = this.leftVRowMeta.indexOfValue(valueMeta.getName())) < 0) continue;
                this.leftValueIndexes.put(i, index);
            }
            for (i = 0; i < this.rightRowMeta.size(); ++i) {
                valueMeta = this.rightRowMeta.getValueMeta(i);
                index = this.rightKRowMeta.indexOfValue(valueMeta.getName());
                if (index >= 0) {
                    this.rightKeyIndexes.put(i, index);
                }
                if ((index = this.rightVRowMeta.indexOfValue(valueMeta.getName())) < 0) continue;
                this.rightValueIndexes.put(i, index);
            }
            Metrics.counter((String)"init", (String)this.counterName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error initializing assembling rows", (Throwable)e);
            throw new RuntimeException("Error initializing assembling output KV<row, KV<row, row>>", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            Integer valueIndex;
            Integer keyIndex;
            int i;
            KV element = (KV)processContext.element();
            KV value = (KV)element.getValue();
            HopRow leftValue = (HopRow)value.getKey();
            HopRow rightValue = (HopRow)value.getValue();
            Object[] outputRow = new Object[this.leftRowMeta.size() + this.rightRowMeta.size()];
            for (i = 0; i < this.leftRowMeta.size(); ++i) {
                if (!leftValue.isNotEmpty()) continue;
                keyIndex = this.leftKeyIndexes.get(i);
                if (keyIndex != null) {
                    outputRow[i] = leftValue.getRow()[keyIndex];
                }
                if ((valueIndex = this.leftValueIndexes.get(i)) == null) continue;
                outputRow[i] = leftValue.getRow()[valueIndex];
            }
            for (i = 0; i < this.rightRowMeta.size(); ++i) {
                if (!rightValue.isNotEmpty()) continue;
                keyIndex = this.rightKeyIndexes.get(i);
                if (keyIndex != null) {
                    outputRow[this.leftRowMeta.size() + i] = rightValue.getRow()[keyIndex];
                }
                if ((valueIndex = this.rightValueIndexes.get(i)) == null) continue;
                outputRow[this.leftRowMeta.size() + i] = rightValue.getRow()[valueIndex];
            }
            processContext.output((Object)new HopRow(outputRow));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error assembling rows", (Throwable)e);
            throw new RuntimeException("Error assembling output KV<row, KV<row, row>>", e);
        }
    }
}

