/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.gui;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigOptionPlugin;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.environment.LifecycleEnvironmentDialog;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.project.ProjectDialog;
import org.apache.hop.projects.util.ProjectsUtil;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.vfs.HopVfsFileDialog;
import org.apache.hop.ui.core.widget.FileTree;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.dialog.PipelineExecutionConfigurationDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engines.local.LocalWorkflowRunConfiguration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ProjectsGuiPlugin {
    public static final Class<?> PKG = ProjectsGuiPlugin.class;
    private static final String LAST_USED_PROJECTS_AUDIT_TYPE = "last-projects";
    private static final int LAST_USED_PROJECTS_MAX_ENTRIES = 15;
    public static final String ID_TOOLBAR_ITEM_PROJECT = "toolbar-item-10000-project";
    public static final String ID_CONTEXT_MENU_PROJECT = "context-menu-project";
    public static final String ID_CONTEXT_MENU_PROJECT_ADD = "context-menu-project-40010-add";
    public static final String ID_CONTEXT_MENU_PROJECT_EDIT = "context-menu-project-40020-edit";
    public static final String ID_CONTEXT_MENU_PROJECT_DELETE = "context-menu-project-40030-delete";
    public static final String ID_TOOLBAR_ITEM_ENVIRONMENT = "toolbar-item-20000-environment";
    public static final String ID_CONTEXT_MENU_ENVIRONMENT = "context-menu-environment";
    public static final String ID_CONTEXT_MENU_ENVIRONMENT_ADD = "context-menu-environment-50010-add";
    public static final String ID_CONTEXT_MENU_ENVIRONMENT_EDIT = "context-menu-environment-50020-edit";
    public static final String ID_CONTEXT_MENU_ENVIRONMENT_DUPLICATE = "context-menu-environment-50030-duplicate";
    public static final String ID_CONTEXT_MENU_ENVIRONMENT_DELETE = "context-menu-environment-50040-delete";
    public static final String ID_MAIN_MENU_PROJECT_EXPORT = "10055-menu-file-export-to-svg";
    public static final String NAVIGATE_TOOLBAR_PARENT_ID = "HopVfsFileDialog-NavigateToolbar";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_PROJECT_HOME = "0005-navigate-project-home";
    FileTree tree;
    private static List<String> lastUsedProjects;

    public static void enableHopGuiProject(String projectName, Project project, LifecycleEnvironment environment) throws HopException {
        try {
            HopGui hopGui = HopGui.getInstance();
            hopGui.auditDelegate.writeLastOpenFiles();
            if (!hopGui.fileDelegate.saveGuardAllFiles()) {
                return;
            }
            hopGui.fileDelegate.closeAllFiles();
            IVariables variables = Variables.getADefaultVariableSpace();
            ArrayList<String> configurationFiles = new ArrayList<String>();
            if (environment != null) {
                configurationFiles.addAll(environment.getConfigurationFiles());
            }
            String environmentName = environment == null ? null : environment.getName();
            ProjectsUtil.enableProject(hopGui.getLog(), projectName, project, variables, configurationFiles, environmentName, (IHasHopMetadataProvider)hopGui);
            IHopMetadataSerializer runConfigSerializer = hopGui.getMetadataProvider().getSerializer(PipelineRunConfiguration.class);
            for (String[] runConfig : runConfigSerializer.loadAll()) {
                for (DescribedVariable variableValueDescription : runConfig.getConfigurationVariables()) {
                    variables.setVariable(variableValueDescription.getName(), "");
                }
            }
            hopGui.setVariables(variables);
            hopGui.auditDelegate.openLastFiles();
            IVariables hopGuiVariables = Variables.getADefaultVariableSpace();
            hopGui.setVariables(hopGuiVariables);
            for (String variable : variables.getVariableNames()) {
                String value = variables.getVariable(variable);
                if (variable.startsWith("Internal")) continue;
                hopGuiVariables.setVariable(variable, value);
            }
            hopGui.getActiveFileTypeHandler().updateGui();
            ProjectsGuiPlugin.rememberLastUsedProjects(projectName);
            ProjectsGuiPlugin.updateProjectToolItem(projectName);
            ProjectsGuiPlugin.updateEnvironmentToolItem(environmentName);
            AuditEvent prjUsedEvent = new AuditEvent("projects", "project", projectName, "open", new Date());
            AuditManager.getActive().storeEvent(prjUsedEvent);
            if (environment != null) {
                AuditEvent envUsedEvent = new AuditEvent("projects", "environment", environmentName, "open", new Date());
                AuditManager.getActive().storeEvent(envUsedEvent);
            }
            hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.ProjectActivated.name()});
            hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.MetadataChanged.name()});
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)hopGuiVariables, (String)HopExtensionPoint.HopGuiProjectAfterEnabled.name(), (Object)((Object)project));
            HopVfs.reset();
        }
        catch (Exception e) {
            throw new HopException("Error enabling project '" + projectName + "' in HopGui", (Throwable)e);
        }
    }

    private static ToolItem getProjectToolItem() {
        return HopGui.getInstance().getStatusToolbarWidgets().findToolItem(ID_TOOLBAR_ITEM_PROJECT);
    }

    private static ToolItem getEnvironmentToolItem() {
        return HopGui.getInstance().getStatusToolbarWidgets().findToolItem(ID_TOOLBAR_ITEM_ENVIRONMENT);
    }

    private static void updateProjectToolItem(String projectName) {
        String projectHome;
        ProjectsConfig config;
        ProjectConfig projectConfig;
        ToolItem item = ProjectsGuiPlugin.getProjectToolItem();
        if (item != null && !item.isDisposed() && (projectConfig = (config = ProjectsConfigSingleton.getConfig()).findProjectConfig(projectName)) != null && StringUtils.isNotEmpty((String)(projectHome = projectConfig.getProjectHome()))) {
            HopGui.getInstance().getStatusToolbarWidgets().setToolbarItemText(ID_TOOLBAR_ITEM_PROJECT, projectName);
            item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Toolbar.Project.Tooltip", (String[])new String[]{projectName, projectHome, projectConfig.getConfigFilename()}));
        }
    }

    private static void updateEnvironmentToolItem(String environmentName) {
        ToolItem item = ProjectsGuiPlugin.getEnvironmentToolItem();
        if (item != null && !item.isDisposed()) {
            if (Utils.isEmpty((CharSequence)environmentName)) {
                HopGui.getInstance().getStatusToolbarWidgets().setToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT, "");
                item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Toolbar.Environment.Select.Tooltip", (String[])new String[0]));
                return;
            }
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            LifecycleEnvironment environment = config.findEnvironment(environmentName);
            if (environment != null) {
                HopGui.getInstance().getStatusToolbarWidgets().setToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT, environmentName);
                item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Toolbar.Environment.Tooltip", (String[])new String[]{environmentName, environment.getProjectName(), environment.getPurpose()}));
            }
        }
    }

    public static List<String> getLastUsedProjects() {
        if (lastUsedProjects == null) {
            List<String> allProjectNames = ProjectsConfigSingleton.getConfig().listProjectConfigNames();
            lastUsedProjects = new LinkedList<String>();
            try {
                AuditList auditList = AuditManager.getActive().retrieveList("hop-gui", LAST_USED_PROJECTS_AUDIT_TYPE);
                for (String name : auditList.getNames()) {
                    if (!allProjectNames.contains(name)) continue;
                    lastUsedProjects.add(name);
                }
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error loading last used projects", (Throwable)e);
                lastUsedProjects.addAll(allProjectNames.subList(0, 15));
            }
        }
        return lastUsedProjects;
    }

    public static void rememberLastUsedProjects(String projectName) {
        ProjectsGuiPlugin.getLastUsedProjects();
        lastUsedProjects.remove(projectName);
        lastUsedProjects.add(0, projectName);
        if (lastUsedProjects.size() > 15) {
            lastUsedProjects = lastUsedProjects.subList(0, 15);
        }
        try {
            AuditList auditList = new AuditList(lastUsedProjects);
            AuditManager.getActive().storeList("hop-gui", LAST_USED_PROJECTS_AUDIT_TYPE, auditList);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error writing list of last used projects last-projects", (Throwable)e);
        }
    }

    public static void enableProject(String projectName) throws HopException {
        HopGui hopGui = HopGui.getInstance();
        IVariables variables = hopGui.getVariables();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            throw new HopException("The project with name '" + projectName + "' could not be found");
        }
        Project project = projectConfig.loadProject(variables);
        ProjectsGuiPlugin.enableHopGuiProject(projectName, project, null);
    }

    @GuiMenuElement(root="context-menu-project", parentId="context-menu-project", id="context-menu-project-40020-edit", label="i18n::HopGui.Toolbar.Project.Edit.Label", toolTip="i18n::HopGui.Toolbar.Project.Edit.Tooltip", image="ui/images/edit.svg")
    public void editProject() {
        HopGui hopGui = HopGui.getInstance();
        String projectName = hopGui.getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        try {
            Project project = projectConfig.loadProject(hopGui.getVariables());
            String projectFolder = projectConfig.getProjectHome();
            ProjectDialog projectDialog = new ProjectDialog(hopGui.getActiveShell(), project, projectConfig, hopGui.getVariables(), true);
            if (projectDialog.open() != null) {
                config.addProjectConfig(projectConfig);
                if (!projectFolder.equals(projectConfig.getProjectHome())) {
                    HopConfig.getInstance().saveToFile();
                }
                if (!projectName.equals(projectConfig.getProjectName())) {
                    projectName = projectConfig.getProjectName();
                    HopConfig.getInstance().saveToFile();
                }
                project.saveToFile();
                ProjectsGuiPlugin.updateProjectToolItem(projectName);
                if (projectDialog.isNeedingProjectRefresh()) {
                    if (this.askAboutProjectRefresh(hopGui)) {
                        LifecycleEnvironment environment = null;
                        ToolItem environmentItem = ProjectsGuiPlugin.getEnvironmentToolItem();
                        if (environmentItem != null) {
                            environment = config.findEnvironment(environmentItem.getText());
                        }
                        ProjectsGuiPlugin.enableHopGuiProject(projectConfig.getProjectName(), project, environment);
                    }
                    hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.ProjectUpdated.name()});
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    private boolean askAboutProjectRefresh(HopGui hopGui) {
        MessageBox box = new MessageBox(hopGui.getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ReloadProject.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ReloadProject.Dialog.Message", (String[])new String[0]));
        int answer = box.open();
        return (answer & 0x40) != 0;
    }

    @GuiToolbarElement(root="HopGui-Status-Toolbar", id="toolbar-item-10000-project", type=GuiToolbarElementType.BUTTON, image="project.svg", toolTip="i18n::HopGui.Toolbar.Project.Tooltip")
    public void showProjectContextMenu() {
        ToolItem item = ProjectsGuiPlugin.getProjectToolItem();
        if (item != null) {
            Rectangle rect = item.getBounds();
            Point location = item.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
            Menu menu = this.createProjectContextMenu();
            menu.setLocation(location);
            menu.setVisible(true);
        }
    }

    private Menu createProjectContextMenu() {
        Shell shell = HopGui.getInstance().getActiveShell();
        Menu menu = new Menu((Decorations)shell, 8);
        GuiMenuWidgets menuWidgets = new GuiMenuWidgets();
        menuWidgets.registerGuiPluginObject((Object)this);
        menuWidgets.createMenuWidgets(ID_CONTEXT_MENU_PROJECT, shell, menu);
        String projectText = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
        boolean enabled = !"".equals(projectText);
        menuWidgets.enableMenuItem(ID_CONTEXT_MENU_PROJECT_EDIT, enabled);
        menuWidgets.enableMenuItem(ID_CONTEXT_MENU_PROJECT_DELETE, enabled);
        new MenuItem(menu, 2);
        ArrayList<String> names = new ArrayList<String>(ProjectsGuiPlugin.getLastUsedProjects());
        if (ProjectsConfigOptionPlugin.getInstance().getSortByNameLastUsedProjects().booleanValue()) {
            names.sort(String::compareToIgnoreCase);
        }
        String currentProjectName = HopNamespace.getNamespace();
        int count = 0;
        for (String name : names) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(name);
            item.addListener(13, e -> this.selectProject(name));
            if (currentProjectName.equals(name)) {
                item.setImage(GuiResource.getInstance().getImageCheck());
            }
            if (++count != 15) continue;
            break;
        }
        new MenuItem(menu, 2);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(BaseMessages.getString(PKG, (String)"HopGui.Toolbar.Project.Select.Tooltip", (String[])new String[0]));
        item.addListener(13, e -> this.selectProject());
        return menu;
    }

    private Menu createEnvironmentContextMenu() {
        Shell shell = HopGui.getInstance().getActiveShell();
        Menu menu = new Menu((Decorations)shell, 8);
        GuiMenuWidgets menuWidgets = new GuiMenuWidgets();
        menuWidgets.registerGuiPluginObject((Object)this);
        menuWidgets.createMenuWidgets(ID_CONTEXT_MENU_ENVIRONMENT, shell, menu);
        String environmentText = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT);
        boolean enabled = !"".equals(environmentText);
        menuWidgets.enableMenuItem(ID_CONTEXT_MENU_ENVIRONMENT_EDIT, enabled);
        menuWidgets.enableMenuItem(ID_CONTEXT_MENU_ENVIRONMENT_DUPLICATE, enabled);
        menuWidgets.enableMenuItem(ID_CONTEXT_MENU_ENVIRONMENT_DELETE, enabled);
        new MenuItem(menu, 2);
        String currentProjectName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
        String currentEnvironmentName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT);
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        List<String> names = config.listEnvironmentNames();
        for (String name : names) {
            LifecycleEnvironment environment = config.findEnvironment(name);
            if (environment == null || !Utils.isEmpty((CharSequence)environment.getProjectName()) && !currentProjectName.equals(environment.getProjectName())) continue;
            String environmentName = name;
            MenuItem item = new MenuItem(menu, 0);
            item.setText(environmentName);
            item.addListener(13, e -> this.selectEnvironment(environmentName));
            if (!currentEnvironmentName.equals(environmentName)) continue;
            item.setImage(GuiResource.getInstance().getImageCheck());
        }
        return menu;
    }

    @GuiToolbarElement(root="HopGui-Status-Toolbar", id="toolbar-item-20000-environment", type=GuiToolbarElementType.BUTTON, image="environment.svg", toolTip="i18n::HopGui.Toolbar.Environment.Tooltip")
    public void showEnvironmentContextMenu() {
        ToolItem item = ProjectsGuiPlugin.getEnvironmentToolItem();
        if (item != null) {
            Rectangle rect = item.getBounds();
            Point location = item.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
            Menu menu = this.createEnvironmentContextMenu();
            menu.setLocation(location);
            menu.setVisible(true);
        }
    }

    public void selectProject() {
        String name;
        List<String> projectNames = ProjectsConfigSingleton.getConfig().listProjectConfigNames();
        projectNames.sort(String::compareToIgnoreCase);
        String[] projects = projectNames.toArray(new String[0]);
        EnterSelectionDialog dialog = new EnterSelectionDialog(HopGui.getInstance().getActiveShell(), projects, BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Dialog.AvailableProjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Dialog.AvailableProjects.Message", (String[])new String[0]));
        String currentProject = HopNamespace.getNamespace();
        dialog.setCurrentValue(currentProject);
        int index = Const.indexOfString((String)currentProject, (String[])projects);
        if (index >= 0) {
            dialog.setSelectedNrs(new int[]{index});
        }
        if ((name = dialog.open()) != null) {
            this.selectProject(name);
        }
    }

    public void selectProject(String projectName) {
        List<LifecycleEnvironment> environments;
        HopGui hopGui = HopGui.getInstance();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        if (config.isEnvironmentsForActiveProject() && StringUtils.isEmpty((String)projectName)) {
            List<String> allEnvironments = config.listEnvironmentNames();
            ProjectsGuiPlugin.updateEnvironmentToolItem(allEnvironments.get(0));
            return;
        }
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        LifecycleEnvironment environment = null;
        try {
            List environmentAuditEvents = AuditManager.findEvents((String)"projects", (String)"environment", (String)"open", (int)100, (boolean)true);
            for (AuditEvent auditEvent : environmentAuditEvents) {
                String environmentName = auditEvent.getName();
                if (!StringUtils.isNotEmpty((String)environmentName) || (environment = config.findEnvironment(environmentName)) == null) continue;
                if (!projectName.equals(environment.getProjectName())) {
                    environment = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error reading the last used environment from the audit logs", (Throwable)e);
        }
        if (environment == null && !(environments = config.findEnvironmentsOfProject(projectName)).isEmpty()) {
            environment = environments.get(0);
        }
        try {
            Project project = projectConfig.loadProject(hopGui.getVariables());
            if (project != null) {
                ProjectsGuiPlugin.enableHopGuiProject(projectName, project, environment);
            } else {
                hopGui.getLog().logError("Unable to find project '" + projectName + "'");
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    @GuiMenuElement(root="context-menu-project", parentId="context-menu-project", id="context-menu-project-40010-add", label="i18n::HopGui.Toolbar.Project.Add.Label", toolTip="i18n::HopGui.Toolbar.Project.Add.Tooltip", image="ui/images/add.svg")
    public void addNewProject() {
        HopGui hopGui = HopGui.getInstance();
        IVariables variables = hopGui.getVariables();
        try {
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            String standardProjectsFolder = variables.resolve(config.getStandardProjectsFolder());
            String defaultProjectConfigFilename = variables.resolve(config.getDefaultProjectConfigFile());
            ProjectConfig projectConfig = new ProjectConfig("", standardProjectsFolder, defaultProjectConfigFilename);
            Project project = new Project();
            project.setParentProjectName(config.getStandardParentProject());
            ProjectDialog projectDialog = new ProjectDialog(hopGui.getActiveShell(), project, projectConfig, variables, false);
            String projectName = projectDialog.open();
            if (projectName != null) {
                MessageBox box;
                config.addProjectConfig(projectConfig);
                HopConfig.getInstance().saveToFile();
                FileObject configFile = HopVfs.getFileObject((String)projectConfig.getActualProjectConfigFilename(variables));
                if (!configFile.exists()) {
                    project.saveToFile();
                } else {
                    MessageBox box2 = new MessageBox(hopGui.getActiveShell(), 36);
                    box2.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ProjectExists.Dialog.Header", (String[])new String[0]));
                    box2.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ProjectExists.Dialog.Message", (String[])new String[0]));
                    box2.open();
                    project.readFromFile();
                }
                ProjectsGuiPlugin.updateProjectToolItem(projectName);
                ProjectsGuiPlugin.enableHopGuiProject(projectName, project, null);
                IHopMetadataSerializer prcSerializer = hopGui.getMetadataProvider().getSerializer(PipelineRunConfiguration.class);
                List pipelineRunConfigs = prcSerializer.loadAll();
                boolean localFound = false;
                for (PipelineRunConfiguration pipelineRunConfig : pipelineRunConfigs) {
                    if (!(pipelineRunConfig.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) continue;
                    localFound = true;
                    break;
                }
                if (!localFound) {
                    PipelineExecutionConfigurationDialog.createLocalPipelineConfiguration((Shell)hopGui.getShell(), (IHopMetadataSerializer)prcSerializer);
                }
                IHopMetadataSerializer wrcSerializer = hopGui.getMetadataProvider().getSerializer(WorkflowRunConfiguration.class);
                localFound = false;
                List workflowRunConfigs = wrcSerializer.loadAll();
                for (WorkflowRunConfiguration workflowRunConfig : workflowRunConfigs) {
                    if (!(workflowRunConfig.getEngineRunConfiguration() instanceof LocalWorkflowRunConfiguration)) continue;
                    localFound = true;
                    break;
                }
                if (!localFound) {
                    box = new MessageBox(HopGui.getInstance().getShell(), 196);
                    box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfig.Dialog.Header", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfig.Dialog.Message", (String[])new String[0]));
                    int answer = box.open();
                    if ((answer & 0x40) != 0) {
                        LocalWorkflowRunConfiguration localWorkflowRunConfiguration = new LocalWorkflowRunConfiguration();
                        localWorkflowRunConfiguration.setEnginePluginId("Local");
                        WorkflowRunConfiguration local = new WorkflowRunConfiguration("local", BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfigDescription.Text", (String[])new String[0]), null, (IWorkflowEngineRunConfiguration)localWorkflowRunConfiguration, true);
                        wrcSerializer.save((IHopMetadata)local);
                    }
                }
                box = new MessageBox(HopGui.getInstance().getShell(), 196);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Message1", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Message2", (String[])new String[0]));
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    this.addNewEnvironment();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddProject.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    @GuiMenuElement(root="context-menu-project", parentId="context-menu-project", id="context-menu-project-40030-delete", label="i18n::HopGui.Toolbar.Project.Delete.Label", toolTip="i18n::HopGui.Toolbar.Project.Delete.Tooltip", image="ui/images/delete.svg")
    public void deleteProject() {
        String projectName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
        if (StringUtils.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig currentProjectConfig = config.findProjectConfig(projectName);
        if (currentProjectConfig == null) {
            return;
        }
        String projectHome = currentProjectConfig.getProjectHome();
        String configFilename = currentProjectConfig.getConfigFilename();
        try {
            List<String> refs = ProjectsUtil.getParentProjectReferences(projectName);
            if (refs.isEmpty()) {
                this.performProjectDeletion(projectName, config, projectHome, configFilename);
            } else {
                String prjReferences = String.join((CharSequence)",", refs);
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Message1", (String[])new String[0]) + Const.CR + prjReferences + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Message2", (String[])new String[0]));
                box.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    private void performProjectDeletion(String projectName, ProjectsConfig config, String projectHome, String configFilename) {
        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Message1", (String[])new String[]{projectName}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Message2", (String[])new String[]{projectHome, configFilename}));
        int answer = box.open();
        if ((answer & 0x40) != 0) {
            try {
                config.removeProjectConfig(projectName);
                ProjectsConfigSingleton.saveConfig();
                if (StringUtils.isEmpty((String)config.getDefaultProject())) {
                    ProjectsGuiPlugin.updateProjectToolItem(null);
                } else {
                    ProjectsGuiPlugin.updateProjectToolItem(config.getDefaultProject());
                }
            }
            catch (Exception e) {
                new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
            }
        }
    }

    @GuiMenuElement(root="context-menu-environment", parentId="context-menu-environment", id="context-menu-environment-50020-edit", label="i18n::HopGui.Toolbar.Environment.Edit.Label", toolTip="i18n::HopGui.Toolbar.Environment.Edit.Tooltip", image="ui/images/edit.svg")
    public void editEnvironment() {
        String environmentName;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT));
        if (environment != null) {
            this.editEnvironment(environment);
        }
    }

    public void editEnvironment(LifecycleEnvironment environment) {
        HopGui hopGui = HopGui.getInstance();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        try {
            LifecycleEnvironmentDialog dialog = new LifecycleEnvironmentDialog(hopGui.getActiveShell(), environment, hopGui.getVariables());
            if (dialog.open() != null) {
                config.addEnvironment(environment);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.updateEnvironmentToolItem(environment.getName());
            }
            if (dialog.isNeedingEnvironmentRefresh() && this.askAboutProjectRefresh(hopGui)) {
                this.selectEnvironment(environment.getName());
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditEnvironment.Error.Dialog.Message", (String[])new String[]{environment.getName()}), e);
        }
    }

    public void selectEnvironment(String environmentName) {
        ProjectConfig projectConfig;
        if (StringUtils.isEmpty((String)environmentName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName);
        if (environment == null) {
            return;
        }
        String projectName = environment.getProjectName();
        if (StringUtils.isEmpty((String)projectName)) {
            projectName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
        }
        if ((projectConfig = config.findProjectConfig(projectName)) == null) {
            return;
        }
        try {
            Project project = projectConfig.loadProject(HopGui.getInstance().getVariables());
            if (project != null) {
                ProjectsGuiPlugin.enableHopGuiProject(projectConfig.getProjectName(), project, environment);
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeEnvironment.Error.Dialog.Message", (String[])new String[]{environmentName}), e);
        }
    }

    @GuiMenuElement(root="context-menu-environment", parentId="context-menu-environment", id="context-menu-environment-50010-add", label="i18n::HopGui.Toolbar.Environment.Add.Label", toolTip="i18n::HopGui.Toolbar.Environment.Add.Tooltip", image="ui/images/add.svg")
    public void addNewEnvironment() {
        HopGui hopGui = HopGui.getInstance();
        try {
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            String projectName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
            LifecycleEnvironment environment = new LifecycleEnvironment(null, "", projectName, new ArrayList<String>());
            LifecycleEnvironmentDialog dialog = new LifecycleEnvironmentDialog(hopGui.getActiveShell(), environment, hopGui.getVariables());
            String environmentName = dialog.open();
            if (environmentName != null) {
                config.addEnvironment(environment);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.updateEnvironmentToolItem(environmentName);
                ProjectConfig projectConfig = config.findProjectConfig(projectName);
                if (projectConfig != null) {
                    Project project = projectConfig.loadProject(hopGui.getVariables());
                    ProjectsGuiPlugin.enableHopGuiProject(projectName, project, environment);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddEnvironment.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    @GuiMenuElement(root="context-menu-environment", parentId="context-menu-environment", id="context-menu-environment-50030-duplicate", label="i18n::HopGui.Toolbar.Environment.Duplicate.Label", toolTip="i18n::HopGui.Toolbar.Environment.Duplicate.Tooltip", image="ui/images/duplicate.svg")
    public void duplicateEnvironment() {
        String environmentName;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT));
        if (environment == null) {
            return;
        }
        LifecycleEnvironment newEnvironment = new LifecycleEnvironment(environment);
        newEnvironment.setName(null);
        this.editEnvironment(newEnvironment);
    }

    @GuiMenuElement(root="context-menu-environment", parentId="context-menu-environment", id="context-menu-environment-50040-delete", label="i18n::HopGui.Toolbar.Environment.Delete.Label", toolTip="i18n::HopGui.Toolbar.Environment.Delete.Tooltip", image="ui/images/delete.svg")
    public void deleteEnvironment() {
        HopGui hopGui = HopGui.getInstance();
        String environmentName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_ENVIRONMENT);
        if (StringUtils.isEmpty((String)environmentName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName);
        if (environment == null) {
            return;
        }
        MessageBox box = new MessageBox(hopGui.getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Message1", (String[])new String[]{environmentName}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Message2", (String[])new String[]{environment.getProjectName()}));
        int answer = box.open();
        if ((answer & 0x40) != 0) {
            try {
                String projectName = HopGui.getInstance().getStatusToolbarWidgets().getToolbarItemText(ID_TOOLBAR_ITEM_PROJECT);
                ProjectConfig projectConfig = config.findProjectConfig(projectName);
                Project project = projectConfig.loadProject(hopGui.getVariables());
                config.removeEnvironment(environmentName);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.updateEnvironmentToolItem(null);
                ProjectsGuiPlugin.enableHopGuiProject(projectName, project, null);
            }
            catch (Exception e) {
                new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Error.Dialog.Message", (String[])new String[]{environmentName}), e);
            }
        }
    }

    public List<String> getProjectsList(ILogChannel log, IHopMetadataProvider metadataProvider) throws Exception {
        List<String> names = ProjectsConfigSingleton.getConfig().listProjectConfigNames();
        HashMap<String, Date> lastUsedMap = new HashMap<String, Date>();
        names.forEach(name -> lastUsedMap.put((String)name, new GregorianCalendar(1900, 0, 1).getTime()));
        List projectOpenEvents = AuditManager.findEvents((String)"projects", (String)"project", (String)"open", (int)100, (boolean)true);
        for (AuditEvent projectOpenEvent : projectOpenEvents) {
            lastUsedMap.put(projectOpenEvent.getName(), projectOpenEvent.getDate());
        }
        names.sort((name1, name2) -> {
            int cmp = -((Date)lastUsedMap.get(name1)).compareTo((Date)lastUsedMap.get(name2));
            if (cmp == 0) {
                cmp = name1.compareToIgnoreCase((String)name2);
            }
            return cmp;
        });
        return names;
    }

    public List<String> getEnvironmentsList(ILogChannel log, IHopMetadataProvider metadataProvider) {
        return ProjectsConfigSingleton.getConfig().listEnvironmentNames();
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0005-navigate-project-home", toolTip="i18n::FileDialog.Browse.Project.Home", image="project.svg")
    public void fileDialogBrowserProjectHome() {
        HopVfsFileDialog instance;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(HopNamespace.getNamespace());
        if (projectConfig == null) {
            return;
        }
        String homeFolder = projectConfig.getProjectHome();
        if (StringUtils.isNotEmpty((String)homeFolder) && (instance = HopVfsFileDialog.getInstance()) != null) {
            instance.navigateTo(homeFolder, true);
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="10055-menu-file-export-to-svg", label="i18n::HopGui.FileMenu.Project.Export.Label", image="export.svg", parentId="10000-menu-file", separator=false)
    public void menuProjectExport() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        IVariables variables = hopGui.getVariables();
        String zipFilename = variables.resolve(BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.zip", "*.*"}, (String[])new String[]{"Zip files (*.zip)", "All Files (*.*)"}, (boolean)true));
        if (zipFilename == null) {
            return;
        }
        ToolItem projectItem = ProjectsGuiPlugin.getProjectToolItem();
        if (projectItem == null) {
            return;
        }
        String projectName = projectItem.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        String projectHome = projectConfig.getProjectHome();
        AtomicBoolean includeVariables = new AtomicBoolean(true);
        AtomicBoolean includeMetadata = new AtomicBoolean(true);
        AtomicBoolean cancel = new AtomicBoolean(true);
        try {
            Shell treeShell = new Shell(shell, 68848);
            treeShell.setText(BaseMessages.getString(PKG, (String)"HopGui.FileMenu.Project.Export.Label", (String[])new String[0]));
            treeShell.setImage(GuiResource.getInstance().getImageHopUi());
            treeShell.setMinimumSize(500, 300);
            PropsUi.setLook((Widget)treeShell);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = PropsUi.getFormMargin();
            formLayout.marginHeight = PropsUi.getFormMargin();
            treeShell.setLayout((Layout)formLayout);
            Button okButton = new Button((Composite)treeShell, 8);
            okButton.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            okButton.addListener(13, event -> {
                cancel.set(false);
                treeShell.dispose();
            });
            Button cancelButton = new Button((Composite)treeShell, 8);
            cancelButton.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            cancelButton.addListener(13, event -> treeShell.dispose());
            BaseTransformDialog.positionBottomButtons((Composite)shell, (Button[])new Button[]{okButton, cancelButton}, (int)PropsUi.getMargin(), null);
            Label separator = new Label((Composite)treeShell, 258);
            separator.setLayoutData((Object)new FormDataBuilder().left().fullWidth().bottom((Control)okButton, -2 * PropsUi.getMargin()).result());
            Button btnIncludeMetadata = new Button((Composite)treeShell, 32);
            PropsUi.setLook((Widget)btnIncludeMetadata);
            btnIncludeMetadata.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.IncludeMetadata.Label", (String[])new String[0]));
            btnIncludeMetadata.setSelection(true);
            btnIncludeMetadata.setLayoutData((Object)new FormDataBuilder().fullWidth().bottom((Control)separator, -2 * PropsUi.getMargin()).result());
            btnIncludeMetadata.addListener(13, event -> includeMetadata.set(btnIncludeMetadata.getSelection()));
            Button btnIncludeVariables = new Button((Composite)treeShell, 32);
            PropsUi.setLook((Widget)btnIncludeVariables);
            btnIncludeVariables.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.IncludeVariables.Label", (String[])new String[0]));
            btnIncludeVariables.setSelection(true);
            btnIncludeVariables.addListener(13, event -> includeVariables.set(btnIncludeVariables.getSelection()));
            btnIncludeVariables.setLayoutData((Object)new FormDataBuilder().fullWidth().bottom((Control)btnIncludeMetadata, -PropsUi.getMargin()).result());
            this.tree = new FileTree((Composite)treeShell, HopVfs.getFileObject((String)projectHome), projectName);
            this.tree.setLayoutData((Object)new FormDataBuilder().top().fullWidth().bottom((Control)btnIncludeVariables, -PropsUi.getMargin()).result());
            BaseTransformDialog.setSize((Shell)treeShell);
            treeShell.setDefaultButton(okButton);
            treeShell.pack();
            treeShell.open();
            while (!treeShell.isDisposed()) {
                if (treeShell.getDisplay().readAndDispatch()) continue;
                treeShell.getDisplay().sleep();
            }
            if (cancel.get()) {
                return;
            }
            IRunnableWithProgress op = monitor -> {
                try {
                    monitor.setTaskName(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Taskname.Text", (String[])new String[0]));
                    HashMap<String, String> variablesMap = new HashMap<String, String>();
                    for (String name : variables.getVariableNames()) {
                        if (name.contains("java.") || name.contains("user.") || name.contains("sun.") || name.contains("os.") || name.contains("file.") || name.contains("jdk.") || name.contains("http.") || name.contains("path.") || name.contains("ftp.") || name.contains("line.") || name.contains("awt.") || name.equals("HOP_METADATA_FOLDER") || name.contains("HOP_ENVIRONMENT_NAME") || name.contains("HOP_AUDIT_FOLDER") || name.contains("HOP_CONFIG_FOLDER") || name.contains("PROJECT_HOME") || name.contains("HOP_PROJECTS") || name.contains("HOP_PLATFORM_OS") || name.contains("HOP_PROJECT_NAME") || name.contains("HOP_SERVER_URL")) continue;
                        String value = variables.getVariable(name);
                        variablesMap.put(name, value);
                    }
                    ObjectMapper objectMapper = new ObjectMapper();
                    String variablesJson = objectMapper.writeValueAsString(variablesMap);
                    SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
                    String metadataJson = metadataProvider.toJson();
                    FileObject zipFile = HopVfs.getFileObject((String)zipFilename);
                    OutputStream outputStream = HopVfs.getOutputStream((FileObject)zipFile, (boolean)false);
                    ZipOutputStream zos = new ZipOutputStream(outputStream);
                    FileObject projectDirectory = HopVfs.getFileObject((String)projectHome);
                    String projectHomeFolder = HopVfs.getFileObject((String)projectHome).getParent().getName().getURI();
                    if (!this.tree.getFileObjects().isEmpty()) {
                        for (FileObject fileObject : this.tree.getFileObjects()) {
                            if (zipFile.equals(fileObject)) continue;
                            monitor.subTask(fileObject.getName().getURI());
                            this.zipFile(fileObject, fileObject.getName().getURI(), zos, projectHomeFolder);
                        }
                    }
                    this.zipFile(HopVfs.getFileObject((String)(Const.HOP_CONFIG_FOLDER + Const.FILE_SEPARATOR + "hop-config.json")), projectDirectory.getName().getBaseName() + Const.FILE_SEPARATOR + "hop-config.json", zos, projectHomeFolder);
                    if (includeVariables.get()) {
                        this.zipString(variablesJson, "variables.json", zos, projectDirectory.getName().getBaseName());
                    }
                    if (includeMetadata.get()) {
                        this.zipString(metadataJson, "metadata.json", zos, projectDirectory.getName().getBaseName());
                    }
                    zos.close();
                    outputStream.close();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error zipping project: " + e.getMessage());
                }
                finally {
                    monitor.done();
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.run(false, op);
            GuiResource.getInstance().toClipboard(zipFilename);
            MessageBox box = new MessageBox(shell, 66);
            box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Message1", (String[])new String[]{zipFilename}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Message2", (String[])new String[0]));
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    public void zipFile(FileObject fileToZip, String filename, ZipOutputStream zipOutputStream, String projectHomeParent) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if ((filename = filename.replace(projectHomeParent, "")).startsWith("/")) {
            filename = filename.substring(1);
        }
        zipOutputStream.putNextEntry(new ZipEntry(filename));
        if (fileToZip.isFolder()) {
            zipOutputStream.closeEntry();
            for (FileObject childFile : fileToZip.getChildren()) {
                this.zipFile(childFile, filename + "/" + childFile.getName().getBaseName(), zipOutputStream, projectHomeParent);
            }
        } else {
            InputStream fis = HopVfs.getInputStream((FileObject)fileToZip);
            fis.transferTo(zipOutputStream);
            fis.close();
            zipOutputStream.closeEntry();
        }
    }

    public void zipString(String stringToZip, String filename, ZipOutputStream zipOutputStream, String projectHomeParent) throws IOException {
        int length;
        if (Utils.isEmpty((CharSequence)stringToZip)) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(stringToZip.getBytes());
        zipOutputStream.putNextEntry(new ZipEntry(projectHomeParent + "/" + filename));
        byte[] bytes = new byte[1024];
        while ((length = bais.read(bytes)) >= 0) {
            zipOutputStream.write(bytes, 0, length);
        }
        zipOutputStream.closeEntry();
        bais.close();
    }
}

