/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import java.io.CharConversionException;

class DBExtendedDataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int FIXED_LENGTH_ = 16;
    private static final int REPEATED_LENGTH_ = 64;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBExtendedDataFormat() {
    }

    public DBExtendedDataFormat(int numberOfFields) {
        this.numberOfFields_ = numberOfFields;
        this.length_ = 16 + this.numberOfFields_ * 64;
    }

    @Override
    public void overlay(byte[] rawBytes, int offset) {
        this.rawBytes_ = rawBytes;
        this.offset_ = offset;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToInt(this.rawBytes_, offset + 4);
            this.length_ = 16 + this.numberOfFields_ * 64;
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    @Override
    public int getLength() {
        return this.length_;
    }

    @Override
    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    @Override
    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    @Override
    public int getRecordSize() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 12);
    }

    @Override
    public int getFieldSQLType(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + fieldIndex * 64);
    }

    @Override
    public int getFieldLength(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + fieldIndex * 64);
    }

    @Override
    public int getArrayFieldLength(int fieldIndex) throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 20 + fieldIndex * 64);
    }

    @Override
    public int getFieldScale(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 24 + fieldIndex * 64);
    }

    @Override
    public int getFieldPrecision(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 26 + fieldIndex * 64);
    }

    @Override
    public int getFieldCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 28 + fieldIndex * 64);
    }

    @Override
    public int getFieldParameterType(int fieldIndex) {
        return this.rawBytes_[this.offset_ + 30 + fieldIndex * 64];
    }

    @Override
    public int getFieldLOBLocator(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 33 + fieldIndex * 64);
    }

    @Override
    public int getFieldLOBMaxSize(int fieldIndex) {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_ + 42 + fieldIndex * 64);
    }

    @Override
    public int getFieldNameLength(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 46 + fieldIndex * 64);
    }

    @Override
    public int getFieldNameCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 48 + fieldIndex * 64);
    }

    @Override
    public String getFieldName(int fieldIndex, ConvTable converter) {
        return converter.byteArrayToString(this.rawBytes_, this.offset_ + 50 + fieldIndex * 64, this.getFieldNameLength(fieldIndex));
    }

    @Override
    public int getUDTNameCCSID(int fieldIndex) {
        return -1;
    }

    @Override
    public String getUDTName(int fieldIndex, ConvTable converter) {
        return null;
    }

    @Override
    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    @Override
    public void setNumberOfFields(int numberOfFields) {
        BinaryConverter.intToByteArray(numberOfFields, this.rawBytes_, this.offset_ + 4);
    }

    @Override
    public void setRecordSize(int recordSize) {
        BinaryConverter.intToByteArray(recordSize, this.rawBytes_, this.offset_ + 12);
    }

    @Override
    public void setFieldDescriptionLength(int fieldIndex) {
        BinaryConverter.shortToByteArray((short)64, this.rawBytes_, this.offset_ + fieldIndex * 64 + 16);
    }

    @Override
    public void setFieldSQLType(int fieldIndex, int sqlType) {
        BinaryConverter.shortToByteArray((short)sqlType, this.rawBytes_, this.offset_ + fieldIndex * 64 + 18);
    }

    @Override
    public void setFieldLength(int fieldIndex, int length) {
        BinaryConverter.intToByteArray(length, this.rawBytes_, this.offset_ + fieldIndex * 64 + 20);
    }

    @Override
    public void setFieldScale(int fieldIndex, int scale) {
        BinaryConverter.shortToByteArray((short)scale, this.rawBytes_, this.offset_ + fieldIndex * 64 + 24);
    }

    @Override
    public void setFieldPrecision(int fieldIndex, int precision) {
        BinaryConverter.shortToByteArray((short)precision, this.rawBytes_, this.offset_ + fieldIndex * 64 + 26);
    }

    @Override
    public void setFieldCCSID(int fieldIndex, int ccsid) {
        BinaryConverter.shortToByteArray((short)ccsid, this.rawBytes_, this.offset_ + fieldIndex * 64 + 28);
    }

    @Override
    public void setFieldParameterType(int fieldIndex, int parameterType) {
        this.rawBytes_[this.offset_ + fieldIndex * 64 + 30] = (byte)parameterType;
    }

    @Override
    public void setFieldNameLength(int fieldIndex, int nameLength) {
        BinaryConverter.shortToByteArray((short)nameLength, this.rawBytes_, this.offset_ + fieldIndex * 64 + 46);
    }

    @Override
    public void setFieldNameCCSID(int fieldIndex, int nameCCSID) {
        BinaryConverter.shortToByteArray((short)nameCCSID, this.rawBytes_, this.offset_ + fieldIndex * 64 + 48);
    }

    @Override
    public void setFieldName(int fieldIndex, String name, ConvTable converter) throws DBDataStreamException {
        try {
            converter.stringToByteArray(name, this.rawBytes_, this.offset_ + fieldIndex * 64 + 50);
        }
        catch (CharConversionException e) {
            throw new DBDataStreamException();
        }
        int length = name.length();
        int padOffset = this.offset_ + fieldIndex * 64 + 50;
        for (int i = length; i < 30; ++i) {
            this.rawBytes_[padOffset + i] = 0;
        }
    }

    @Override
    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public boolean getCSRSData() {
        return this.csRsData_;
    }

    @Override
    public void setCSRSData(boolean csRsData) {
        this.csRsData_ = csRsData;
    }

    @Override
    public int getXMLCharType(int fieldIndex) {
        return -1;
    }

    @Override
    public int getArrayType(int fieldIndex) {
        return -1;
    }
}

