/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.SizeEstimator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SideInputBroadcast<@UnknownKeyFor T>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SideInputBroadcast.class);
    private @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> bcast;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private transient T value;
    private transient @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes = null;
    private  @UnknownKeyFor @NonNull @Initialized SparkPCollectionView.Type sparkPCollectionViewType;

    private SideInputBroadcast(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized Coder<T> coder,  @UnknownKeyFor @NonNull @Initialized SparkPCollectionView.Type sparkPCollectionViewType) {
        this.bytes = bytes;
        this.coder = coder;
        this.sparkPCollectionViewType = sparkPCollectionViewType;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<T> create(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes,  @UnknownKeyFor @NonNull @Initialized SparkPCollectionView.Type type, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return new SideInputBroadcast<T>(bytes, coder, type);
    }

    public synchronized T getValue() {
        if (this.value == null) {
            this.value = this.deserialize();
        }
        return this.value;
    }

    public void broadcast(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc) {
        this.bcast = jsc.broadcast((Object)this.bytes);
    }

    public  @UnknownKeyFor @NonNull @Initialized SparkPCollectionView.Type getSparkPCollectionViewType() {
        return this.sparkPCollectionViewType;
    }

    public void unpersist() {
        this.bcast.unpersist();
    }

    private T deserialize() {
        Object val;
        try {
            val = this.coder.decode((InputStream)new ByteArrayInputStream((byte[])this.bcast.value()));
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage());
            val = null;
        }
        return (T)val;
    }

    public @UnknownKeyFor @NonNull @Initialized long getBroadcastSizeEstimate() {
        return SizeEstimator.estimate((Object)this.bytes);
    }
}

