/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProperties
implements Cloneable {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalProperties.class);
    public static final LocalProperties EMPTY = new LocalProperties();
    private Ordering ordering;
    private FieldList groupedFields;
    private Set<FieldSet> uniqueFields;

    public Ordering getOrdering() {
        return this.ordering;
    }

    public FieldList getGroupedFields() {
        return this.groupedFields;
    }

    public Set<FieldSet> getUniqueFields() {
        return this.uniqueFields;
    }

    public boolean areFieldsUnique(FieldSet set) {
        return this.uniqueFields != null && this.uniqueFields.contains(set);
    }

    public LocalProperties addUniqueFields(FieldSet uniqueFields) {
        LocalProperties copy = this.clone();
        if (copy.uniqueFields == null) {
            copy.uniqueFields = new HashSet<FieldSet>();
        }
        copy.uniqueFields.add(uniqueFields);
        return copy;
    }

    public LocalProperties clearUniqueFieldSets() {
        if (this.uniqueFields == null || this.uniqueFields.isEmpty()) {
            return this;
        }
        LocalProperties copy = new LocalProperties();
        copy.ordering = this.ordering;
        copy.groupedFields = this.groupedFields;
        return copy;
    }

    public boolean isTrivial() {
        return this.ordering == null && this.groupedFields == null && this.uniqueFields == null;
    }

    public LocalProperties filterBySemanticProperties(SemanticProperties props, int input) {
        FieldSet targetField;
        if (props == null) {
            throw new NullPointerException("SemanticProperties may not be null.");
        }
        LocalProperties returnProps = new LocalProperties();
        if (this.ordering != null) {
            Ordering newOrdering = new Ordering();
            for (int i = 0; i < this.ordering.getInvolvedIndexes().size(); ++i) {
                int sourceField = this.ordering.getInvolvedIndexes().get(i);
                targetField = props.getForwardingTargetFields(input, sourceField);
                if (targetField == null || targetField.size() == 0) {
                    if (i != 0) break;
                    newOrdering = null;
                    break;
                }
                if (targetField.size() > 1) {
                    LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                }
                newOrdering.appendOrdering(Integer.valueOf(targetField.toArray()[0]), this.ordering.getType(i), this.ordering.getOrder(i));
            }
            returnProps.ordering = newOrdering;
            returnProps.groupedFields = newOrdering != null ? newOrdering.getInvolvedIndexes() : null;
        } else if (this.groupedFields != null) {
            FieldList newGroupedFields = new FieldList();
            for (Integer sourceField : this.groupedFields) {
                targetField = props.getForwardingTargetFields(input, sourceField.intValue());
                if (targetField == null || targetField.size() == 0) {
                    newGroupedFields = null;
                    break;
                }
                if (targetField.size() > 1) {
                    LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                }
                newGroupedFields = newGroupedFields.addField(Integer.valueOf(targetField.toArray()[0]));
            }
            returnProps.groupedFields = newGroupedFields;
        }
        if (this.uniqueFields != null) {
            HashSet<FieldSet> newUniqueFields = new HashSet<FieldSet>();
            for (FieldSet fields : this.uniqueFields) {
                FieldSet newFields = new FieldSet();
                for (Integer sourceField : fields) {
                    FieldSet targetField2 = props.getForwardingTargetFields(input, sourceField.intValue());
                    if (targetField2 == null || targetField2.size() == 0) {
                        newFields = null;
                        break;
                    }
                    if (targetField2.size() > 1) {
                        LOG.warn("Found that a field is forwarded to more than one target field in semantic forwarded field information. Will only use the field with the lowest index.");
                    }
                    newFields = newFields.addField(Integer.valueOf(targetField2.toArray()[0]));
                }
                if (newFields == null) continue;
                newUniqueFields.add(newFields);
            }
            returnProps.uniqueFields = !newUniqueFields.isEmpty() ? newUniqueFields : null;
        }
        return returnProps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        result = 31 * result + (this.groupedFields == null ? 0 : this.groupedFields.hashCode());
        result = 31 * result + (this.uniqueFields == null ? 0 : this.uniqueFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalProperties) {
            LocalProperties other = (LocalProperties)obj;
            return (this.ordering == other.getOrdering() || this.ordering != null && this.ordering.equals((Object)other.getOrdering())) && (this.groupedFields == other.getGroupedFields() || this.groupedFields != null && this.groupedFields.equals((Object)other.getGroupedFields())) && (this.uniqueFields == other.getUniqueFields() || this.uniqueFields != null && this.uniqueFields.equals(other.getUniqueFields()));
        }
        return false;
    }

    public String toString() {
        return "LocalProperties [ordering=" + this.ordering + ", grouped=" + this.groupedFields + ", unique=" + this.uniqueFields + "]";
    }

    public LocalProperties clone() {
        LocalProperties copy = new LocalProperties();
        copy.ordering = this.ordering;
        copy.groupedFields = this.groupedFields;
        copy.uniqueFields = this.uniqueFields == null ? null : new HashSet<FieldSet>(this.uniqueFields);
        return copy;
    }

    public static LocalProperties combine(LocalProperties lp1, LocalProperties lp2) {
        if (lp1.ordering != null) {
            return lp1;
        }
        if (lp2.ordering != null) {
            return lp2;
        }
        if (lp1.groupedFields != null) {
            return lp1;
        }
        if (lp2.groupedFields != null) {
            return lp2;
        }
        if (lp1.uniqueFields != null && !lp1.uniqueFields.isEmpty()) {
            return lp1;
        }
        if (lp2.uniqueFields != null && !lp2.uniqueFields.isEmpty()) {
            return lp2;
        }
        return lp1;
    }

    public static LocalProperties forOrdering(Ordering o) {
        LocalProperties props = new LocalProperties();
        props.ordering = o;
        props.groupedFields = o.getInvolvedIndexes();
        return props;
    }

    public static LocalProperties forGrouping(FieldList groupedFields) {
        LocalProperties props = new LocalProperties();
        props.groupedFields = groupedFields;
        return props;
    }
}

