/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Objects;
import org.apache.beam.runners.core.metrics.DirtyState;
import org.apache.beam.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class HistogramCell
implements Histogram,
MetricCell<HistogramData> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private final @UnknownKeyFor @NonNull @Initialized HistogramData value;
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public HistogramCell(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType> kv) {
        this.name = kv.getKey();
        this.value = new HistogramData(kv.getValue());
    }

    @Override
    public void reset() {
        this.value.clear();
        this.dirty.reset();
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized double value) {
        this.value.record(value);
        this.dirty.afterModification();
    }

    public void update(@UnknownKeyFor @NonNull @Initialized HistogramCell other) {
        this.value.update(other.value);
        this.dirty.afterModification();
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized HistogramData data) {
        this.value.update(data);
        this.dirty.afterModification();
    }

    public void incBucketCount(@UnknownKeyFor @NonNull @Initialized int bucketIndex, @UnknownKeyFor @NonNull @Initialized long count) {
        this.value.incBucketCount(bucketIndex, count);
        this.dirty.afterModification();
    }

    public void incTopBucketCount(@UnknownKeyFor @NonNull @Initialized long count) {
        this.value.incTopBucketCount(count);
        this.dirty.afterModification();
    }

    public void incBottomBucketCount(@UnknownKeyFor @NonNull @Initialized long count) {
        this.value.incBottomBucketCount(count);
        this.dirty.afterModification();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HistogramData getCumulative() {
        return this.value;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof HistogramCell) {
            HistogramCell histogramCell = (HistogramCell)object;
            return Objects.equals(this.dirty, histogramCell.dirty) && Objects.equals(this.value, histogramCell.value) && Objects.equals(this.name, histogramCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.value, this.name);
    }
}

