/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

public class SearchUtils {
    public static int getOptimalStringAlignmentDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] d = new int[n + 1];
        int[] p1 = new int[n + 1];
        int[] p2 = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p1[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                char s_i = s.charAt(i - 1);
                int cost = s_i == t_j ? 0 : 1;
                int deletion = d[i - 1] + 1;
                int insertion = p1[i] + 1;
                int substitution = p1[i - 1] + cost;
                d[i] = Math.min(Math.min(deletion, insertion), substitution);
                if (i <= 1 || j <= 1 || s_i != t.charAt(j - 2) || s.charAt(i - 2) != t_j) continue;
                d[i] = Math.min(d[i], p2[i - 2] + cost);
            }
            int[] _d = p2;
            p2 = p1;
            p1 = d;
            d = _d;
        }
        return p1[n];
    }
}

