/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.binary;

import org.psjava.ds.tree.binary.BinaryTreeNodeWithParent;
import org.psjava.util.AssertStatus;

public class BinaryTreeNodeUtil {
    public static <T> boolean isLeftChild(BinaryTreeNodeWithParent<T> node) {
        return node.getParent().hasLeft() && node.getParent().getLeft() == node;
    }

    public static <T> BinaryTreeNodeWithParent<T> getAnyChild(BinaryTreeNodeWithParent<T> node) {
        if (node.hasLeft()) {
            return node.getLeft();
        }
        return node.getRight();
    }

    public static <T> void replaceNode(BinaryTreeNodeWithParent<T> originalNode, BinaryTreeNodeWithParent<T> newNode) {
        BinaryTreeNodeWithParent<T> parent = originalNode.getParent();
        boolean left = BinaryTreeNodeUtil.isLeftChild(originalNode);
        BinaryTreeNodeUtil.disconnectFromParent(originalNode);
        if (left) {
            BinaryTreeNodeUtil.connectAsLeftChild(newNode, parent);
        } else {
            BinaryTreeNodeUtil.connectAsRightChild(newNode, parent);
        }
    }

    public static <T> void connectAsLeftChild(BinaryTreeNodeWithParent<T> node, BinaryTreeNodeWithParent<T> parent) {
        AssertStatus.assertTrue(!parent.hasLeft());
        AssertStatus.assertTrue(!node.hasParent());
        parent.putLeft(node);
        node.putParent(parent);
    }

    public static <T> void connectAsRightChild(BinaryTreeNodeWithParent<T> node, BinaryTreeNodeWithParent<T> parent) {
        AssertStatus.assertTrue(!parent.hasRight());
        AssertStatus.assertTrue(!node.hasParent());
        parent.putRight(node);
        node.putParent(parent);
    }

    public static <T> void disconnectFromParent(BinaryTreeNodeWithParent<T> node) {
        BinaryTreeNodeWithParent<T> parent = node.getParent();
        if (BinaryTreeNodeUtil.isLeftChild(node)) {
            parent.removeLeft();
        } else {
            parent.removeRight();
        }
        node.removeParent();
    }

    private BinaryTreeNodeUtil() {
    }
}

