/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async.xp;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.async.AsyncWebService;
import org.apache.hop.www.async.Defaults;

@ExtensionPoint(id="PeriodicPipelineStatusUpdateExtensionPoint", extensionPointId="PipelinePrepareExecution", description="A pipeline is being prepared for execution.  If the parent is a pipeline action and a service is set: monitor")
public class PeriodicPipelineStatusUpdateExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables iVariables, final IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        if (!(pipeline.getParent() instanceof IAction)) {
            return;
        }
        IAction action = (IAction)pipeline.getParent();
        if (!action.isPipeline()) {
            return;
        }
        IWorkflowEngine workflow = action.getParentWorkflow();
        Map extensionDataMap = workflow.getExtensionDataMap();
        final AsyncWebService service = (AsyncWebService)((Object)extensionDataMap.get(Defaults.createWorkflowExtensionDataKey(action.getName())));
        if (service == null) {
            return;
        }
        final IWorkflowEngine<WorkflowMeta> grandParentWorkflow = this.getGrandParentWorkflow(pipeline);
        if (grandParentWorkflow == null) {
            pipeline.getLogChannel().logError("WARNING: the grand parent workflow for pipeline '" + pipeline.getObjectName() + "' couldn't be found");
            return;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    PeriodicPipelineStatusUpdateExtensionPoint.this.updatePipelineStatus((IPipelineEngine<PipelineMeta>)pipeline, service, (IWorkflowEngine<WorkflowMeta>)grandParentWorkflow);
                }
                catch (IOException e) {
                    pipeline.getLogChannel().logError("Error updating async service pipeline status", (Throwable)e);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(timerTask, 0L, 1000L);
        pipeline.addExecutionFinishedListener(engine -> {
            timerTask.cancel();
            ExecutorUtil.cleanup((Timer)timer);
            try {
                this.updatePipelineStatus((IPipelineEngine<PipelineMeta>)engine, service, grandParentWorkflow);
            }
            catch (IOException e) {
                engine.getLogChannel().logError("Error updating async service pipeline status", (Throwable)e);
            }
        });
    }

    private void updatePipelineStatus(IPipelineEngine<PipelineMeta> pipeline, AsyncWebService service, IWorkflowEngine<WorkflowMeta> grandParentWorkflow) throws IOException {
        HopServerPipelineStatus status = this.getPipelineStatus(pipeline);
        String key = Defaults.createWorkflowPipelineStatusExtensionDataKey(pipeline.getObjectName(), service.getName());
        grandParentWorkflow.getExtensionDataMap().put(key, status);
    }

    private IWorkflowEngine<WorkflowMeta> getGrandParentWorkflow(IPipelineEngine<PipelineMeta> pipeline) {
        if (pipeline.getParentWorkflow() != null) {
            return this.getGrandParentWorkflow((IWorkflowEngine<WorkflowMeta>)pipeline.getParentWorkflow());
        }
        if (pipeline.getParentPipeline() != null) {
            return this.getGrandParentWorkflow((IPipelineEngine<PipelineMeta>)pipeline.getParentPipeline());
        }
        return null;
    }

    private IWorkflowEngine<WorkflowMeta> getGrandParentWorkflow(IWorkflowEngine<WorkflowMeta> workflow) {
        if (workflow.getParentWorkflow() != null) {
            return this.getGrandParentWorkflow((IWorkflowEngine<WorkflowMeta>)workflow.getParentWorkflow());
        }
        if (workflow.getParentPipeline() != null) {
            return this.getGrandParentWorkflow((IPipelineEngine<PipelineMeta>)workflow.getParentPipeline());
        }
        return workflow;
    }

    private HopServerPipelineStatus getPipelineStatus(IPipelineEngine<PipelineMeta> pipeline) throws IOException {
        HopServerPipelineStatus pipelineStatus = new HopServerPipelineStatus(pipeline.getPipelineMeta().getName(), pipeline.getContainerId(), pipeline.getStatusDescription());
        String logText = HopLogStore.getAppender().getBuffer(pipeline.getLogChannel().getLogChannelId(), false).toString();
        pipelineStatus.setFirstLoggingLineNr(-1);
        pipelineStatus.setLastLoggingLineNr(-1);
        pipelineStatus.setLogDate(new Date());
        pipelineStatus.setExecutionStartDate(pipeline.getExecutionStartDate());
        pipelineStatus.setExecutionEndDate(pipeline.getExecutionEndDate());
        for (IEngineComponent component : pipeline.getComponents()) {
            if (!component.isRunning() && component.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_EMPTY) continue;
            TransformStatus transformStatus = new TransformStatus(component);
            pipelineStatus.getTransformStatusList().add(transformStatus);
        }
        String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
        pipelineStatus.setLoggingString(loggingString);
        pipelineStatus.setPaused(pipeline.isPaused());
        return pipelineStatus;
    }
}

