/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.config;

import org.apache.hc.core5.http.config.NamedElementChain;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class TestNamedElementChain {
    TestNamedElementChain() {
    }

    @Test
    void testBasics() {
        NamedElementChain list = new NamedElementChain();
        MatcherAssert.assertThat((Object)list.getFirst(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)list.getLast(), (Matcher)CoreMatchers.nullValue());
        NamedElementChain.Node nodeA = list.addFirst((Object)Character.valueOf('a'), "a");
        MatcherAssert.assertThat((Object)list.getFirst(), (Matcher)CoreMatchers.sameInstance((Object)nodeA));
        MatcherAssert.assertThat((Object)list.getLast(), (Matcher)CoreMatchers.sameInstance((Object)nodeA));
        NamedElementChain.Node nodeB = list.addLast((Object)Character.valueOf('b'), "b");
        MatcherAssert.assertThat((Object)list.getFirst(), (Matcher)CoreMatchers.sameInstance((Object)nodeA));
        MatcherAssert.assertThat((Object)list.getLast(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        NamedElementChain.Node nodeZ = list.addLast((Object)Character.valueOf('z'), "z");
        MatcherAssert.assertThat((Object)list.getFirst(), (Matcher)CoreMatchers.sameInstance((Object)nodeA));
        MatcherAssert.assertThat((Object)list.getLast(), (Matcher)CoreMatchers.sameInstance((Object)nodeZ));
        MatcherAssert.assertThat((Object)nodeA.getPrevious(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)nodeA.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        MatcherAssert.assertThat((Object)nodeB.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeA));
        MatcherAssert.assertThat((Object)nodeB.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeZ));
        MatcherAssert.assertThat((Object)nodeZ.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        MatcherAssert.assertThat((Object)nodeZ.getNext(), (Matcher)CoreMatchers.nullValue());
        NamedElementChain.Node nodeD = list.addAfter("b", (Object)Character.valueOf('d'), "d");
        MatcherAssert.assertThat((Object)nodeD.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        MatcherAssert.assertThat((Object)nodeD.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeZ));
        MatcherAssert.assertThat((Object)nodeB.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeD));
        MatcherAssert.assertThat((Object)nodeZ.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeD));
        NamedElementChain.Node nodeC = list.addBefore("d", (Object)Character.valueOf('c'), "c");
        MatcherAssert.assertThat((Object)nodeC.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        MatcherAssert.assertThat((Object)nodeC.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeD));
        MatcherAssert.assertThat((Object)nodeB.getNext(), (Matcher)CoreMatchers.sameInstance((Object)nodeC));
        MatcherAssert.assertThat((Object)nodeD.getPrevious(), (Matcher)CoreMatchers.sameInstance((Object)nodeC));
        MatcherAssert.assertThat((Object)list.getSize(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)list.remove("a"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)list.remove("z"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)list.remove("c"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)list.remove("c"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)list.remove("blah"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)list.getFirst(), (Matcher)CoreMatchers.sameInstance((Object)nodeB));
        MatcherAssert.assertThat((Object)list.getLast(), (Matcher)CoreMatchers.sameInstance((Object)nodeD));
        MatcherAssert.assertThat((Object)list.getSize(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)list.addBefore("blah", (Object)Character.valueOf('e'), "e"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)list.getSize(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)list.addAfter("yada", (Object)Character.valueOf('e'), "e"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)list.getSize(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void testFind() {
        NamedElementChain list = new NamedElementChain();
        list.addLast((Object)Character.valueOf('c'), "c");
        MatcherAssert.assertThat((Object)list.find("c"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)list.find("a"), (Matcher)Matchers.nullValue());
    }

    @Test
    void testReplace() {
        NamedElementChain list = new NamedElementChain();
        list.addLast((Object)Character.valueOf('c'), "c");
        boolean found = list.replace("c", (Object)Character.valueOf('z'));
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)list.find("c").getValue(), (Matcher)Matchers.equalTo((Object)Character.valueOf('z')));
        MatcherAssert.assertThat((Object)list.find("c").getName(), (Matcher)Matchers.equalTo((Object)"c"));
        boolean notFound = list.replace("X", (Object)Character.valueOf('z'));
        MatcherAssert.assertThat((Object)notFound, (Matcher)CoreMatchers.is((Object)false));
    }
}

