/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.testing.nio.IOReactorExecutor;
import org.apache.hc.core5.testing.nio.LoggingExceptionCallback;
import org.apache.hc.core5.testing.nio.LoggingIOSessionDecorator;
import org.apache.hc.core5.testing.nio.LoggingIOSessionListener;
import org.apache.hc.core5.testing.nio.LoggingReactorMetricsListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class AsyncRequester
extends IOReactorExecutor<DefaultConnectingIOReactor>
implements ConnectionInitiator {
    public AsyncRequester(IOReactorConfig ioReactorConfig) {
        super(ioReactorConfig, null);
    }

    @Override
    DefaultConnectingIOReactor createIOReactor(IOEventHandlerFactory ioEventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Callback<IOSession> sessionShutdownCallback) throws IOException {
        return new DefaultConnectingIOReactor(ioEventHandlerFactory, ioReactorConfig, threadFactory, (Decorator)LoggingIOSessionDecorator.INSTANCE, (Callback)LoggingExceptionCallback.INSTANCE, (IOSessionListener)LoggingIOSessionListener.INSTANCE, LoggingReactorMetricsListener.INSTANCE, sessionShutdownCallback, null);
    }

    private InetSocketAddress toSocketAddress(HttpHost host) {
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        String hostName = host.getHostName();
        return new InetSocketAddress(hostName, port);
    }

    public Future<IOSession> requestSession(HttpHost host, Timeout timeout, FutureCallback<IOSession> callback) {
        Args.notNull((Object)host, (String)"Host");
        return ((DefaultConnectingIOReactor)this.reactor()).connect((NamedEndpoint)host, (SocketAddress)this.toSocketAddress(host), null, timeout, null, callback);
    }

    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) {
        return ((DefaultConnectingIOReactor)this.reactor()).connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
    }
}

