/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cdc.CdcResendCommandArg;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.CdcDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CdcCacheDataResendTask
extends VisorMultiNodeTask<CdcResendCommandArg, Void, Void> {
    private static final long serialVersionUID = 0L;
    private AffinityTopologyVersion topVer;

    @Override
    protected VisorJob<CdcResendCommandArg, Void> job(CdcResendCommandArg arg) {
        return new CdcCacheDataResendJob(arg, this.topVer);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<CdcResendCommandArg> arg) {
        GridDhtPartitionsExchangeFuture fut = this.ignite.context().cache().context().exchange().lastFinishedFuture();
        if (!fut.rebalanced()) {
            throw new IgniteException("CDC cache data resend cancelled. Rebalance sheduled [topVer=" + fut.topologyVersion() + "]");
        }
        this.topVer = this.ignite.context().cache().context().exchange().lastAffinityChangedTopologyVersion(fut.topologyVersion());
        return F.nodeIds(this.ignite.cluster().forServers().nodes());
    }

    @Override
    @Nullable
    protected Void reduce0(List<ComputeJobResult> results) throws IgniteException {
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            throw new IgniteException("CDC cache data resend cancelled. Failed to resend cache data on the node [nodeId=" + res.getNode().id() + "]", res.getException());
        }
        return null;
    }

    private static class CdcCacheDataResendJob
    extends VisorJob<CdcResendCommandArg, Void> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        protected IgniteLogger log;
        private IgniteWriteAheadLogManager wal;
        private GridCachePartitionExchangeManager<Object, Object> exchange;
        private final AffinityTopologyVersion topVer;
        private GridDhtPartitionsExchangeFuture lastFut;

        protected CdcCacheDataResendJob(CdcResendCommandArg arg, AffinityTopologyVersion topVer) {
            super(arg, false);
            this.topVer = topVer;
        }

        @Override
        protected Void run(CdcResendCommandArg arg) throws IgniteException {
            if (F.isEmpty(arg.caches())) {
                throw new IllegalArgumentException("Caches are not specified.");
            }
            ArrayList caches = new ArrayList();
            for (String name : arg.caches()) {
                IgniteInternalCache cache = this.ignite.context().cache().cache(name);
                if (cache == null) {
                    throw new IgniteException("Cache does not exist [cacheName=" + name + "]");
                }
                if (!cache.context().dataRegion().config().isCdcEnabled()) {
                    throw new IgniteException("CDC is not enabled for given cache [cacheName=" + name + ", dataRegionName=" + cache.context().dataRegion().config().getName() + "]");
                }
                caches.add(cache);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("CDC cache data resend started [caches=" + String.join((CharSequence)", ", arg.caches()) + "]");
            }
            this.wal = this.ignite.context().cache().context().wal(true);
            this.exchange = this.ignite.context().cache().context().exchange();
            try {
                Iterator iter = caches.iterator();
                while (iter.hasNext() && !this.isCancelled()) {
                    this.resendCacheData((IgniteInternalCache)iter.next());
                }
                this.wal.flush(null, true);
                if (this.log.isInfoEnabled()) {
                    this.log.info("CDC cache data resend " + (this.isCancelled() ? "cancelled" : "finished") + " [caches=" + String.join((CharSequence)", ", arg.caches()) + "]");
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return null;
        }

        private void resendCacheData(IgniteInternalCache<?, ?> cache) throws IgniteCheckedException {
            if (this.log.isInfoEnabled()) {
                this.log.info("CDC cache data resend started [cacheName=" + cache.name() + "]");
            }
            GridCacheContext<?, ?> cctx = cache.context();
            GridIterator<CacheDataRow> locRows = cctx.offheap().cacheIterator(cctx.cacheId(), true, false, AffinityTopologyVersion.NONE, null);
            long cnt = 0L;
            TreeSet<Integer> parts = new TreeSet<Integer>();
            for (CacheDataRow row : locRows) {
                GridCacheVersion ver;
                if (this.isCancelled()) break;
                this.ensureTopologyNotChanged();
                KeyCacheObject key = row.key();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Resend key: " + key);
                }
                if ((ver = row.version()) instanceof GridCacheVersionEx) {
                    ver = new GridCacheVersion(ver.topologyVersion(), ver.order(), ver.nodeOrder(), ver.clusterId());
                }
                CdcDataRecord rec = new CdcDataRecord(new DataEntry(cctx.cacheId(), key, row.value(), GridCacheOperation.CREATE, null, ver, row.expireTime(), key.partition(), -1L, DataEntry.flags(true)));
                this.wal.log(rec);
                parts.add(key.partition());
                if (++cnt % 1000L != 0L || !this.log.isDebugEnabled()) continue;
                this.log.debug("Resend entries count: " + cnt);
            }
            if (this.log.isInfoEnabled()) {
                if (this.isCancelled()) {
                    this.log.info("CDC cache data resend cancelled.");
                } else {
                    this.log.info("CDC cache data resend finished [cacheName=" + cache.name() + ", entriesCnt=" + cnt + ", parts=" + parts + "]");
                }
            }
        }

        private void ensureTopologyNotChanged() {
            GridDhtPartitionsExchangeFuture fut = this.exchange.lastFinishedFuture();
            if (this.lastFut != fut) {
                AffinityTopologyVersion lastChanged = this.exchange.lastAffinityChangedTopologyVersion(fut.topologyVersion());
                if (!this.topVer.equals(lastChanged)) {
                    throw new IgniteException("CDC cache data resend cancelled. Topology changed during resend [startTopVer=" + this.topVer + ", currentTopVer=" + fut.topologyVersion() + "]");
                }
                this.lastFut = fut;
            }
        }
    }
}

