/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.jackson.IgniteObjectMapper;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.request.DataStructuresRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestBaselineRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterNameRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestLogRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestNodeStateBeforeStartRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTaskRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTopologyRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestWarmUpRequest;
import org.apache.ignite.internal.processors.rest.request.RestQueryRequest;
import org.apache.ignite.internal.processors.rest.request.RestUserActionRequest;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jetbrains.annotations.Nullable;

public class GridJettyRestHandler
extends AbstractHandler {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private static final String FAILED_TO_PARSE_FORMAT = "Failed to parse parameter of %s type [%s=%s]";
    private static final String USER_PARAM = "user";
    private static final String PWD_PARAM = "password";
    private static final String CACHE_NAME_PARAM = "cacheName";
    private static final String BACKUPS_PARAM = "backups";
    private static final String CACHE_GROUP_PARAM = "cacheGroup";
    private static final String DATA_REGION_PARAM = "dataRegion";
    private static final String WRITE_SYNCHRONIZATION_MODE_PARAM = "writeSynchronizationMode";
    private static final String IGNITE_LOGIN = "ignite.login";
    private static final String IGNITE_PASSWORD = "ignite.password";
    private static final String TEMPLATE_NAME_PARAM = "templateName";
    private static final NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private final IgniteLogger log;
    private final IgniteClosure<String, Boolean> authChecker;
    private GridRestProtocolHandler hnd;
    private volatile String dfltPage;
    private volatile byte[] favicon;
    private final ObjectMapper jsonMapper;
    private final boolean getAllAsArray = IgniteSystemProperties.getBoolean((String)"IGNITE_REST_GETALL_AS_ARRAY");

    GridJettyRestHandler(GridRestProtocolHandler hnd, C1<String, Boolean> authChecker, GridKernalContext ctx) {
        assert (hnd != null);
        assert (ctx != null);
        this.hnd = hnd;
        this.authChecker = authChecker;
        this.log = ctx.log(((Object)((Object)this)).getClass());
        this.jsonMapper = new IgniteObjectMapper(ctx);
        try {
            this.initDefaultPage();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized default page.");
            }
        }
        catch (IOException e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to initialize default page: " + e.getMessage()));
        }
        try {
            this.initFavicon();
            if (this.log.isDebugEnabled()) {
                this.log.debug((String)(this.favicon != null ? "Initialized favicon, size: " + this.favicon.length : "Favicon is null."));
            }
        }
        catch (IOException e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to initialize favicon: " + e.getMessage()));
        }
    }

    @Nullable
    private static Long longValue(String key, Map<String, String> params, Long dfltVal) throws IgniteCheckedException {
        assert (key != null);
        String val = params.get(key);
        try {
            return val == null ? dfltVal : Long.valueOf(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException(String.format(FAILED_TO_PARSE_FORMAT, "Long", key, val));
        }
    }

    private static boolean booleanValue(String key, Map<String, String> params, boolean dfltVal) {
        assert (key != null);
        String val = params.get(key);
        return val == null ? dfltVal : Boolean.parseBoolean(val);
    }

    private static int intValue(String key, Map<String, String> params, int dfltVal) throws IgniteCheckedException {
        assert (key != null);
        String val = params.get(key);
        try {
            return val == null ? dfltVal : Integer.parseInt(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException(String.format(FAILED_TO_PARSE_FORMAT, "Integer", key, val));
        }
    }

    @Nullable
    private static <T extends Enum<T>> T enumValue(String key, Map<String, String> params, Class<T> enumClass) throws IgniteCheckedException {
        assert (key != null);
        assert (enumClass != null);
        String val = params.get(key);
        if (val == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, val);
        }
        catch (IllegalArgumentException e) {
            throw new IgniteCheckedException(String.format(FAILED_TO_PARSE_FORMAT, enumClass.getSimpleName(), key, val), (Throwable)e);
        }
    }

    @Nullable
    private static UUID uuidValue(String key, Map<String, String> params) throws IgniteCheckedException {
        assert (key != null);
        String val = params.get(key);
        try {
            return val == null ? null : UUID.fromString(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException(String.format(FAILED_TO_PARSE_FORMAT, "UUID", key, val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultPage() throws IOException {
        assert (this.dfltPage == null);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("rest.html");
        if (in != null) {
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(in, CHARSET));
            try {
                StringBuilder buf = new StringBuilder(2048);
                String line = rdr.readLine();
                while (line != null) {
                    buf.append(line);
                    if (!line.endsWith(" ")) {
                        buf.append(' ');
                    }
                    line = rdr.readLine();
                }
                this.dfltPage = buf.toString();
            }
            finally {
                U.closeQuiet((AutoCloseable)rdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFavicon() throws IOException {
        assert (this.favicon == null);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("favicon.ico");
        if (in != null) {
            BufferedInputStream bis = new BufferedInputStream(in);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int n;
                byte[] buf = new byte[2048];
                while ((n = bis.read(buf)) != -1) {
                    bos.write(buf, 0, n);
                }
                this.favicon = bos.toByteArray();
            }
            finally {
                U.closeQuiet((AutoCloseable)bis);
            }
        }
    }

    public void handle(String target, Request req, HttpServletRequest srvReq, HttpServletResponse res) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling request [target=" + target + ", req=" + req + ", srvReq=" + srvReq + "]");
        }
        if (target.startsWith("/ignite")) {
            this.processRequest(target, srvReq, res);
            req.setHandled(true);
        } else if (target.startsWith("/favicon.ico")) {
            if (this.favicon == null) {
                res.setStatus(404);
                req.setHandled(true);
                return;
            }
            res.setStatus(200);
            res.setContentType("image/x-icon");
            res.getOutputStream().write(this.favicon);
            res.getOutputStream().flush();
            req.setHandled(true);
        } else {
            if (this.dfltPage == null) {
                res.setStatus(404);
                req.setHandled(true);
                return;
            }
            res.setStatus(200);
            res.setContentType("text/html");
            res.getWriter().write(this.dfltPage);
            res.getWriter().flush();
            req.setHandled(true);
        }
    }

    private void processRequest(String act, HttpServletRequest req, HttpServletResponse res) {
        GridRestResponse cmdRes;
        res.setContentType("application/json");
        res.setCharacterEncoding("UTF-8");
        GridRestCommand cmd = this.command((ServletRequest)req);
        if (cmd == null) {
            res.setStatus(400);
            return;
        }
        if (!((Boolean)this.authChecker.apply((Object)req.getHeader("X-Signature"))).booleanValue()) {
            res.setStatus(401);
            return;
        }
        Map<String, String> params = this.parameters((ServletRequest)req);
        try {
            byte[] sesTok;
            GridRestRequest cmdReq = this.createRequest(cmd, params, req);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized command request: " + cmdReq);
            }
            if ((cmdRes = this.hnd.handle(cmdReq)) == null) {
                throw new IllegalStateException("Received null result from handler: " + this.hnd);
            }
            if (this.getAllAsArray && cmd == GridRestCommand.CACHE_GET_ALL) {
                ArrayList<IgniteBiTuple> resKeyVal = new ArrayList<IgniteBiTuple>();
                for (Map.Entry me : ((Map)cmdRes.getResponse()).entrySet()) {
                    resKeyVal.add(new IgniteBiTuple(me.getKey(), me.getValue()));
                }
                cmdRes.setResponse(resKeyVal);
            }
            if ((sesTok = cmdRes.sessionTokenBytes()) != null) {
                cmdRes.setSessionToken(U.byteArray2HexString((byte[])sesTok));
            }
            res.setStatus(cmdRes.getSuccessStatus() == 503 ? 503 : 200);
        }
        catch (Throwable e) {
            res.setStatus(200);
            U.error((IgniteLogger)this.log, (Object)("Failed to process HTTP request [action=" + act + ", req=" + req + "]"), (Throwable)e);
            if (e instanceof Error) {
                throw (Error)e;
            }
            cmdRes = new GridRestResponse(1, e.getMessage());
        }
        try (ServletOutputStream os = res.getOutputStream();){
            try {
                this.jsonMapper.writeValue((OutputStream)NULL_OUTPUT_STREAM, (Object)cmdRes);
                this.jsonMapper.writeValue((OutputStream)os, (Object)cmdRes);
            }
            catch (JsonProcessingException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to convert response to JSON: " + cmdRes), (Throwable)e);
                this.jsonMapper.writeValue((OutputStream)os, (Object)new GridRestResponse(1, e.getMessage()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processed HTTP request [action=" + act + ", jsonRes=" + cmdRes + ", req=" + req + "]");
            }
        }
        catch (IOException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to send HTTP response: " + cmdRes), (Throwable)e);
        }
    }

    @Nullable
    private GridRestRequest createRequest(GridRestCommand cmd, Map<String, String> params, HttpServletRequest req) throws IgniteCheckedException {
        GridRestRequest restReq;
        switch (cmd) {
            case GET_OR_CREATE_CACHE: {
                String wrtSyncMode;
                String dataRegion;
                String cacheGrp;
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                restReq0.cacheName(params.get(CACHE_NAME_PARAM));
                String templateName = params.get(TEMPLATE_NAME_PARAM);
                if (!F.isEmpty((String)templateName)) {
                    restReq0.templateName(templateName);
                }
                String backups = params.get(BACKUPS_PARAM);
                CacheConfigurationOverride cfg = new CacheConfigurationOverride();
                if (!F.isEmpty((String)backups)) {
                    try {
                        cfg.backups(Integer.valueOf(Integer.parseInt(backups)));
                    }
                    catch (NumberFormatException e) {
                        throw new IgniteCheckedException("Failed to parse number of cache backups: " + backups, (Throwable)e);
                    }
                }
                if (!F.isEmpty((String)(cacheGrp = params.get(CACHE_GROUP_PARAM)))) {
                    cfg.cacheGroup(cacheGrp);
                }
                if (!F.isEmpty((String)(dataRegion = params.get(DATA_REGION_PARAM)))) {
                    cfg.dataRegion(dataRegion);
                }
                if (!F.isEmpty((String)(wrtSyncMode = params.get(WRITE_SYNCHRONIZATION_MODE_PARAM)))) {
                    try {
                        cfg.writeSynchronizationMode(CacheWriteSynchronizationMode.valueOf((String)wrtSyncMode));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Failed to parse cache write synchronization mode: " + wrtSyncMode, (Throwable)e);
                    }
                }
                if (!cfg.isEmpty()) {
                    restReq0.configuration(cfg);
                }
                restReq = restReq0;
                break;
            }
            case DESTROY_CACHE: {
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                restReq0.cacheName(params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            case ATOMIC_DECREMENT: 
            case ATOMIC_INCREMENT: {
                GridRestCacheRequest restReq0 = new DataStructuresRequest();
                restReq0.key((Object)params.get("key"));
                restReq0.initial(GridJettyRestHandler.longValue("init", params, null));
                restReq0.delta(GridJettyRestHandler.longValue("delta", params, null));
                restReq = restReq0;
                break;
            }
            case CACHE_CONTAINS_KEY: 
            case CACHE_CONTAINS_KEYS: 
            case CACHE_GET: 
            case CACHE_GET_ALL: 
            case CACHE_GET_AND_PUT: 
            case CACHE_GET_AND_REPLACE: 
            case CACHE_PUT_IF_ABSENT: 
            case CACHE_GET_AND_PUT_IF_ABSENT: 
            case CACHE_PUT: 
            case CACHE_PUT_ALL: 
            case CACHE_REMOVE: 
            case CACHE_REMOVE_VALUE: 
            case CACHE_REPLACE_VALUE: 
            case CACHE_GET_AND_REMOVE: 
            case CACHE_REMOVE_ALL: 
            case CACHE_CLEAR: 
            case CACHE_ADD: 
            case CACHE_CAS: 
            case CACHE_METRICS: 
            case CACHE_SIZE: 
            case CACHE_UPDATE_TLL: 
            case CACHE_METADATA: 
            case CACHE_REPLACE: 
            case CACHE_APPEND: 
            case CACHE_PREPEND: {
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                String cacheName = params.get(CACHE_NAME_PARAM);
                restReq0.cacheName(F.isEmpty((String)cacheName) ? null : cacheName);
                String keyType = params.get("keyType");
                String valType = params.get("valueType");
                Converter converter = new Converter(cacheName);
                restReq0.key(converter.convert(keyType, params.get("key")));
                restReq0.value(converter.convert(valType, params.get("val")));
                restReq0.value2(converter.convert(valType, params.get("val2")));
                Object val1 = converter.convert(valType, params.get("val1"));
                if (val1 != null) {
                    restReq0.value(val1);
                }
                restReq0.cacheFlags(GridJettyRestHandler.intValue("cacheFlags", params, 2));
                restReq0.ttl(GridJettyRestHandler.longValue("exp", params, null));
                if (cmd == GridRestCommand.CACHE_GET_ALL || cmd == GridRestCommand.CACHE_PUT_ALL || cmd == GridRestCommand.CACHE_REMOVE_ALL || cmd == GridRestCommand.CACHE_CONTAINS_KEYS) {
                    List<Object> keys = converter.values(keyType, "k", params);
                    List<Object> vals = converter.values(valType, "v", params);
                    if (keys.size() < vals.size()) {
                        throw new IgniteCheckedException("Number of keys must be greater or equals to number of values.");
                    }
                    HashMap map = U.newHashMap((int)keys.size());
                    Iterator<Object> keyIt = keys.iterator();
                    Iterator<Object> valIt = vals.iterator();
                    while (keyIt.hasNext()) {
                        map.put(keyIt.next(), valIt.hasNext() ? valIt.next() : null);
                    }
                    restReq0.values((Map)map);
                }
                restReq = restReq0;
                break;
            }
            case TOPOLOGY: 
            case NODE: {
                GridRestCacheRequest restReq0 = new GridRestTopologyRequest();
                restReq0.includeMetrics(Boolean.parseBoolean(params.get("mtr")));
                restReq0.includeAttributes(Boolean.parseBoolean(params.get("attr")));
                String caches = params.get("caches");
                restReq0.includeCaches(caches == null || Boolean.parseBoolean(caches));
                restReq0.nodeIp(params.get("ip"));
                restReq0.nodeId(GridJettyRestHandler.uuidValue("id", params));
                restReq = restReq0;
                break;
            }
            case EXE: 
            case RESULT: 
            case NOOP: {
                GridRestCacheRequest restReq0 = new GridRestTaskRequest();
                restReq0.taskId(params.get("id"));
                restReq0.taskName(params.get("name"));
                restReq0.params(new Converter().values(null, "p", params));
                restReq0.async(Boolean.parseBoolean(params.get("async")));
                restReq0.timeout(GridJettyRestHandler.longValue("timeout", params, 0L).longValue());
                restReq = restReq0;
                break;
            }
            case LOG: {
                GridRestCacheRequest restReq0 = new GridRestLogRequest();
                restReq0.path(params.get("path"));
                restReq0.from(GridJettyRestHandler.intValue("from", params, -1));
                restReq0.to(GridJettyRestHandler.intValue("to", params, -1));
                restReq = restReq0;
                break;
            }
            case DATA_REGION_METRICS: 
            case NAME: 
            case VERSION: 
            case PROBE: {
                restReq = new GridRestRequest();
                break;
            }
            case CLUSTER_ACTIVE: 
            case CLUSTER_INACTIVE: 
            case CLUSTER_ACTIVATE: 
            case CLUSTER_DEACTIVATE: 
            case CLUSTER_CURRENT_STATE: {
                GridRestCacheRequest restReq0 = new GridRestChangeStateRequest();
                if (cmd == GridRestCommand.CLUSTER_CURRENT_STATE) {
                    restReq0.reqCurrentState();
                } else if (cmd == GridRestCommand.CLUSTER_ACTIVE || cmd == GridRestCommand.CLUSTER_ACTIVATE) {
                    restReq0.active(true);
                } else {
                    restReq0.active(false);
                }
                restReq0.forceDeactivation(GridJettyRestHandler.booleanValue("force", params, false));
                restReq = restReq0;
                break;
            }
            case CLUSTER_STATE: 
            case CLUSTER_SET_STATE: {
                GridRestCacheRequest restReq0 = new GridRestClusterStateRequest();
                if (cmd == GridRestCommand.CLUSTER_STATE) {
                    restReq0.reqCurrentMode();
                } else {
                    ClusterState newState = GridJettyRestHandler.enumValue("state", params, ClusterState.class);
                    restReq0.state(newState);
                    restReq0.forceDeactivation(GridJettyRestHandler.booleanValue("force", params, false));
                }
                restReq = restReq0;
                break;
            }
            case CLUSTER_NAME: {
                restReq = new GridRestClusterNameRequest();
                break;
            }
            case BASELINE_CURRENT_STATE: 
            case BASELINE_SET: 
            case BASELINE_ADD: 
            case BASELINE_REMOVE: {
                GridRestCacheRequest restReq0 = new GridRestBaselineRequest();
                restReq0.topologyVersion(GridJettyRestHandler.longValue("topVer", params, null));
                restReq0.consistentIds(new Converter().values(null, "consistentId", params));
                restReq = restReq0;
                break;
            }
            case AUTHENTICATE: {
                restReq = new GridRestRequest();
                break;
            }
            case ADD_USER: 
            case REMOVE_USER: 
            case UPDATE_USER: {
                GridRestCacheRequest restReq0 = new RestUserActionRequest();
                restReq0.user(params.get(USER_PARAM));
                restReq0.password(params.get(PWD_PARAM));
                restReq = restReq0;
                break;
            }
            case EXECUTE_SQL_QUERY: 
            case EXECUTE_SQL_FIELDS_QUERY: {
                String distributedJoins;
                String keepBinary;
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                String cacheName = params.get(CACHE_NAME_PARAM);
                restReq0.sqlQuery(params.get("qry"));
                restReq0.arguments(new Converter(cacheName).values(null, "arg", params).toArray());
                restReq0.typeName(params.get("type"));
                String pageSize = params.get("pageSize");
                if (pageSize != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                if ((keepBinary = params.get("keepBinary")) != null) {
                    restReq0.keepBinary(Boolean.parseBoolean(keepBinary));
                }
                if ((distributedJoins = params.get("distributedJoins")) != null) {
                    restReq0.distributedJoins(Boolean.parseBoolean(distributedJoins));
                }
                restReq0.cacheName(cacheName);
                if (cmd == GridRestCommand.EXECUTE_SQL_QUERY) {
                    restReq0.queryType(RestQueryRequest.QueryType.SQL);
                } else {
                    restReq0.queryType(RestQueryRequest.QueryType.SQL_FIELDS);
                }
                restReq = restReq0;
                break;
            }
            case EXECUTE_SCAN_QUERY: {
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                restReq0.sqlQuery(params.get("qry"));
                String pageSize = params.get("pageSize");
                if (pageSize != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                restReq0.cacheName(params.get(CACHE_NAME_PARAM));
                restReq0.className(params.get("className"));
                restReq0.queryType(RestQueryRequest.QueryType.SCAN);
                restReq = restReq0;
                break;
            }
            case FETCH_SQL_QUERY: {
                String pageSize;
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                String qryId = params.get("qryId");
                if (qryId != null) {
                    restReq0.queryId(Long.valueOf(Long.parseLong(qryId)));
                }
                if ((pageSize = params.get("pageSize")) != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                restReq0.cacheName(params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            case CLOSE_SQL_QUERY: {
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                String qryId = params.get("qryId");
                if (qryId != null) {
                    restReq0.queryId(Long.valueOf(Long.parseLong(qryId)));
                }
                restReq0.cacheName(params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            case NODE_STATE_BEFORE_START: {
                restReq = new GridRestNodeStateBeforeStartRequest();
                break;
            }
            case WARM_UP: {
                GridRestCacheRequest restReq0 = new GridRestWarmUpRequest();
                restReq0.stopWarmUp(Boolean.parseBoolean(String.valueOf(params.get("stopWarmUp"))));
                restReq = restReq0;
                break;
            }
            default: {
                throw new IgniteCheckedException("Invalid command: " + cmd);
            }
        }
        restReq.address(new InetSocketAddress(req.getRemoteAddr(), req.getRemotePort()));
        restReq.command(cmd);
        Object certs = req.getAttribute("javax.servlet.request.X509Certificate");
        if (certs instanceof X509Certificate[]) {
            restReq.certificates((Certificate[])((X509Certificate[])certs));
        }
        if (!this.credentials(params, IGNITE_LOGIN, IGNITE_PASSWORD, restReq)) {
            this.credentials(params, USER_PARAM, PWD_PARAM, restReq);
        }
        String clientId = params.get("clientId");
        try {
            if (clientId != null) {
                restReq.clientId(UUID.fromString(clientId));
            }
        }
        catch (Exception pageSize) {
            // empty catch block
        }
        String destId = params.get("destId");
        try {
            if (destId != null) {
                restReq.destinationId(UUID.fromString(destId));
            }
        }
        catch (IllegalArgumentException keepBinary) {
            // empty catch block
        }
        String sesTokStr = params.get("sessionToken");
        try {
            byte[] bytes;
            if (sesTokStr != null && (bytes = U.hexString2ByteArray((String)sesTokStr)).length == 16) {
                restReq.sessionToken(bytes);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return restReq;
    }

    private boolean credentials(Map<String, String> params, String userParam, String pwdParam, GridRestRequest restReq) {
        boolean hasCreds;
        boolean bl = hasCreds = params.containsKey(userParam) || params.containsKey(pwdParam);
        if (hasCreds) {
            SecurityCredentials cred = new SecurityCredentials(params.get(userParam), params.get(pwdParam));
            restReq.credentials((Object)cred);
        }
        return hasCreds;
    }

    @Nullable
    private GridRestCommand command(ServletRequest req) {
        String cmd = req.getParameter("cmd");
        return cmd == null ? null : GridRestCommand.fromKey((String)cmd.toLowerCase());
    }

    private Map<String, String> parameters(ServletRequest req) {
        Map params = req.getParameterMap();
        if (F.isEmpty((Map)params)) {
            return Collections.emptyMap();
        }
        HashMap map = U.newHashMap((int)params.size());
        for (Map.Entry entry : params.entrySet()) {
            map.put((String)entry.getKey(), this.parameter(entry.getValue()));
        }
        return map;
    }

    @Nullable
    private String parameter(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[] && ((String[])obj).length > 0) {
            return ((String[])obj)[0];
        }
        return null;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    }

    private class Converter {
        private final String cacheName;

        private Converter(String cacheName) {
            this.cacheName = cacheName;
        }

        private Converter() {
            this(null);
        }

        private List<Object> values(String type, String keyPrefix, Map<String, String> params) throws IgniteCheckedException {
            String key;
            assert (keyPrefix != null);
            LinkedList<Object> vals = new LinkedList<Object>();
            int i = 1;
            while (params.containsKey(key = keyPrefix + i)) {
                vals.add(this.convert(type, params.get(key)));
                ++i;
            }
            return vals;
        }

        private Object convert(@Nullable String type, @Nullable String str) throws IgniteCheckedException {
            if (F.isEmpty((String)type) || str == null) {
                return str;
            }
            try {
                switch (type.toLowerCase()) {
                    case "boolean": 
                    case "java.lang.boolean": {
                        return Boolean.valueOf(str);
                    }
                    case "byte": 
                    case "java.lang.byte": {
                        return Byte.valueOf(str);
                    }
                    case "short": 
                    case "java.lang.short": {
                        return Short.valueOf(str);
                    }
                    case "int": 
                    case "integer": 
                    case "java.lang.integer": {
                        return Integer.valueOf(str);
                    }
                    case "long": 
                    case "java.lang.long": {
                        return Long.valueOf(str);
                    }
                    case "float": 
                    case "java.lang.float": {
                        return Float.valueOf(str);
                    }
                    case "double": 
                    case "java.lang.double": {
                        return Double.valueOf(str);
                    }
                    case "date": 
                    case "java.sql.date": {
                        return Date.valueOf(str);
                    }
                    case "time": 
                    case "java.sql.time": {
                        return Time.valueOf(str);
                    }
                    case "timestamp": 
                    case "java.sql.timestamp": {
                        return Timestamp.valueOf(str);
                    }
                    case "uuid": 
                    case "java.util.uuid": {
                        return UUID.fromString(str);
                    }
                    case "igniteuuid": 
                    case "org.apache.ignite.lang.igniteuuid": {
                        return IgniteUuid.fromString((String)str);
                    }
                    case "string": 
                    case "java.lang.string": {
                        return str;
                    }
                }
                Class cls = U.classForName((String)type, null);
                if (cls != null) {
                    return GridJettyRestHandler.this.jsonMapper.readValue(str, cls);
                }
                InjectableValues.Std prop = new InjectableValues.Std().addValue("binaryTypeName", (Object)type).addValue(GridJettyRestHandler.CACHE_NAME_PARAM, (Object)this.cacheName);
                return GridJettyRestHandler.this.jsonMapper.reader((InjectableValues)prop).forType(BinaryObject.class).readValue(str);
            }
            catch (Throwable e) {
                throw new IgniteCheckedException("Failed to convert value to specified type [type=" + type + ", val=" + str + ", reason=" + e.getClass().getName() + ": " + e.getMessage() + "]", e);
            }
        }
    }
}

