/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class DataRecord
extends TimeStampRecord {
    @GridToStringInclude
    private Object writeEntries;

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_RECORD_V2;
    }

    private DataRecord() {
    }

    public DataRecord(DataEntry writeEntry) {
        this(writeEntry, U.currentTimeMillis());
    }

    public DataRecord(List<DataEntry> writeEntries) {
        this(writeEntries, U.currentTimeMillis());
    }

    public DataRecord(Object writeEntries, long timestamp) {
        super(timestamp);
        A.notNull(writeEntries, "writeEntries");
        this.writeEntries = writeEntries;
    }

    public DataRecord setWriteEntries(List<DataEntry> writeEntries) {
        this.writeEntries = writeEntries;
        return this;
    }

    public List<DataEntry> writeEntries() {
        if (this.writeEntries instanceof DataEntry) {
            return Collections.singletonList((DataEntry)this.writeEntries);
        }
        return (List)this.writeEntries;
    }

    public int entryCount() {
        return this.writeEntries instanceof DataEntry ? 1 : ((List)this.writeEntries).size();
    }

    public DataEntry get(int idx) {
        if (this.writeEntries instanceof DataEntry) {
            assert (idx == 0);
            return (DataEntry)this.writeEntries;
        }
        return (DataEntry)((List)this.writeEntries).get(idx);
    }

    @Override
    public String toString() {
        return S.toString(DataRecord.class, this, "super", (Object)super.toString());
    }
}

