/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessageBuilder;

class ZonePartitionIdMessageDeserializer
implements MessageDeserializer<ZonePartitionIdMessage> {
    private final ZonePartitionIdMessageBuilder msg;

    ZonePartitionIdMessageDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.zonePartitionIdMessage();
    }

    public Class<ZonePartitionIdMessage> klass() {
        return ZonePartitionIdMessage.class;
    }

    public ZonePartitionIdMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("zoneId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.zoneId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ZonePartitionIdMessage.class);
    }
}

