/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessageBuilder;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;

class LocalPartitionStateMessageDeserializer
implements MessageDeserializer<LocalPartitionStateMessage> {
    private final LocalPartitionStateMessageBuilder msg;

    LocalPartitionStateMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localPartitionStateMessage();
    }

    public Class<LocalPartitionStateMessage> klass() {
        return LocalPartitionStateMessage.class;
    }

    public LocalPartitionStateMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("estimatedRows");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.estimatedRows(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("logIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.logIndex(tmp);
                reader.incrementState();
            }
            case 2: {
                TablePartitionIdMessage tmp = (TablePartitionIdMessage)reader.readMessage("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 3: {
                int ordinalShifted = reader.readInt("state");
                if (!reader.isLastRead()) {
                    return false;
                }
                LocalPartitionStateEnum tmp = ordinalShifted == 0 ? null : LocalPartitionStateEnum.fromOrdinal(ordinalShifted - 1);
                this.msg.state(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalPartitionStateMessage.class);
    }
}

