/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.Internal;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

@Internal
public class ApiResponsesDeserializer
extends JsonDeserializer<ApiResponses> {
    protected boolean openapi31;

    public ApiResponses deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = this.openapi31 ? ConvertUtils.getJsonMapper31() : ConvertUtils.getJsonMapper();
        ApiResponses result = new ApiResponses();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ObjectNode objectNode = (ObjectNode)node;
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Iterator it = objectNode.fieldNames();
        while (it.hasNext()) {
            String childName = (String)it.next();
            JsonNode child = objectNode.get(childName);
            if (childName.startsWith("x-")) {
                extensions.put(childName, mapper.convertValue((Object)child, Object.class));
                continue;
            }
            result.put((Object)childName, (Object)((ApiResponse)mapper.convertValue((Object)child, ApiResponse.class)));
        }
        if (!extensions.isEmpty()) {
            result.setExtensions(extensions);
        }
        return result;
    }
}

