/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageBuilder;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartResponseMessageImpl
implements HandshakeStartResponseMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final ClusterNodeMessage clientNode;
    @IgniteToStringInclude
    private final short connectionId;
    @IgniteToStringInclude
    private final long receivedCount;

    private HandshakeStartResponseMessageImpl(ClusterNodeMessage clientNode, short connectionId, long receivedCount) {
        this.clientNode = clientNode;
        this.connectionId = connectionId;
        this.receivedCount = receivedCount;
    }

    @Override
    public ClusterNodeMessage clientNode() {
        return this.clientNode;
    }

    @Override
    public short connectionId() {
        return this.connectionId;
    }

    @Override
    public long receivedCount() {
        return this.receivedCount;
    }

    public MessageSerializer serializer() {
        return HandshakeStartResponseMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartResponseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartResponseMessageImpl otherMessage = (HandshakeStartResponseMessageImpl)other;
        return Objects.equals(this.clientNode, otherMessage.clientNode) && this.connectionId == otherMessage.connectionId && this.receivedCount == otherMessage.receivedCount;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.connectionId, this.receivedCount, this.clientNode);
        return result;
    }

    public HandshakeStartResponseMessageImpl clone() {
        try {
            return (HandshakeStartResponseMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeStartResponseMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clientNode != null) {
            this.clientNode.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clientNode != null) {
            this.clientNode.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements HandshakeStartResponseMessageBuilder {
        private ClusterNodeMessage clientNode;
        private short connectionId;
        private long receivedCount;

        private Builder() {
        }

        @Override
        public HandshakeStartResponseMessageBuilder clientNode(ClusterNodeMessage clientNode) {
            Objects.requireNonNull(clientNode, "clientNode is not marked @Nullable");
            this.clientNode = clientNode;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageBuilder connectionId(short connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageBuilder receivedCount(long receivedCount) {
            this.receivedCount = receivedCount;
            return this;
        }

        @Override
        public ClusterNodeMessage clientNode() {
            return this.clientNode;
        }

        @Override
        public short connectionId() {
            return this.connectionId;
        }

        @Override
        public long receivedCount() {
            return this.receivedCount;
        }

        @Override
        public HandshakeStartResponseMessage build() {
            return new HandshakeStartResponseMessageImpl(Objects.requireNonNull(this.clientNode, "clientNode is not marked @Nullable"), this.connectionId, this.receivedCount);
        }
    }
}

