/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.shaded.org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.shaded.org.apache.ignite.lang.IgniteException;
import org.apache.ignite.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.shaded.org.apache.ignite.table.QualifiedName;

public class ColumnNotFoundException
extends IgniteException {
    public ColumnNotFoundException(String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, "Column does not exist [name=" + IgniteNameUtils.quoteIfNeeded(columnName) + "]");
    }

    public ColumnNotFoundException(QualifiedName tableName, String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, "Column does not exist [tableName=" + tableName.toCanonicalForm() + ", columnName=" + IgniteNameUtils.quoteIfNeeded(columnName) + "]");
    }

    public ColumnNotFoundException(UUID traceId, int code, String message, Throwable cause) {
        super(traceId, code, message, cause);
    }
}

