/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.AsofJoin;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.CorrelationReferenceFinder;
import org.apache.calcite.sql2rel.RexRewritingRelShuttle;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelFieldTrimmer
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<TrimResult> trimFieldsDispatcher;
    private final RelBuilder relBuilder;

    public RelFieldTrimmer(@Nullable SqlValidator validator, RelBuilder relBuilder) {
        Util.discard(validator);
        this.relBuilder = relBuilder;
        ReflectUtil.MethodDispatcher<TrimResult> dispatcher = ReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, ImmutableBitSet.class, Set.class);
        this.trimFieldsDispatcher = dispatcher;
    }

    @Deprecated
    public RelFieldTrimmer(@Nullable SqlValidator validator, RelOptCluster cluster, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory) {
        this(validator, RelBuilder.proto(projectFactory, filterFactory, joinFactory, sortFactory, aggregateFactory, setOpFactory).create(cluster, null));
    }

    public RelNode trim(RelNode root) {
        int fieldCount = root.getRowType().getFieldCount();
        ImmutableBitSet fieldsUsed = ImmutableBitSet.range(fieldCount);
        Set<RelDataTypeField> extraFields = Collections.emptySet();
        TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
        if (!((Mapping)trimResult.right).isIdentity()) {
            throw new IllegalArgumentException();
        }
        if (SqlToRelConverter.SQL2REL_LOGGER.isDebugEnabled()) {
            SqlToRelConverter.SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after trimming unused fields", (RelNode)trimResult.left, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        return (RelNode)trimResult.left;
    }

    protected TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        final ImmutableBitSet.Builder fieldsUsedBuilder = fieldsUsed.rebuild();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        ImmutableList<RelCollation> collations = mq.collations(input);
        if (collations != null) {
            for (RelCollation collation : collations) {
                for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                    fieldsUsedBuilder.set(fieldCollation.getFieldIndex());
                }
            }
        }
        for (final CorrelationId correlation : rel.getVariablesSet()) {
            rel.accept(new CorrelationReferenceFinder(){

                @Override
                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals(correlation)) {
                        fieldsUsedBuilder.set(fieldAccess.getField().getIndex());
                    }
                    return fieldAccess;
                }
            });
        }
        return this.dispatchTrimFields(input, fieldsUsedBuilder.build(), extraFields);
    }

    protected TrimResult trimChildRestore(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimChild(rel, input, fieldsUsed, extraFields);
        if (((Mapping)trimResult.right).isIdentity()) {
            return trimResult;
        }
        RelDataType rowType = input.getRowType();
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        ArrayList<RexLiteral> exprList = new ArrayList<RexLiteral>();
        List<String> nameList = rowType.getFieldNames();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        assert (((Mapping)trimResult.right).getSourceCount() == fieldList.size());
        for (int i = 0; i < fieldList.size(); ++i) {
            int source = ((Mapping)trimResult.right).getTargetOpt(i);
            RelDataTypeField field = fieldList.get(i);
            exprList.add((RexLiteral)(source < 0 ? rexBuilder.makeZeroLiteral(field.getType()) : rexBuilder.makeInputRef(field.getType(), source)));
        }
        this.relBuilder.push((RelNode)trimResult.left).project(exprList, nameList);
        return this.result(this.relBuilder.build(), Mappings.createIdentity(fieldList.size()), rel);
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimFieldsDispatcher.invoke(rel, fieldsUsed, extraFields);
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return this.result(rel, mapping);
        }
        return trimResult;
    }

    protected TrimResult result(RelNode rel, Mapping mapping, RelNode oldRel) {
        return this.result(RelOptUtil.copyRelHints(oldRel, rel), mapping);
    }

    protected TrimResult result(RelNode r, final Mapping mapping) {
        final RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        for (final CorrelationId correlation : r.getVariablesSet()) {
            r = r.accept(new CorrelationReferenceFinder(){

                @Override
                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals(correlation) && v.getType().getFieldCount() == mapping.getSourceCount()) {
                        int old = fieldAccess.getField().getIndex();
                        int new_ = mapping.getTarget(old);
                        RelDataTypeFactory.FieldInfoBuilder typeBuilder = RelFieldTrimmer.this.relBuilder.getTypeFactory().builder();
                        for (int target : Util.range(mapping.getTargetCount())) {
                            ((RelDataTypeFactory.Builder)typeBuilder).add(v.getType().getFieldList().get(mapping.getSource(target)));
                        }
                        RexNode newV = rexBuilder.makeCorrel(typeBuilder.build(), v.id);
                        if (old != new_) {
                            return rexBuilder.makeFieldAccess(newV, new_);
                        }
                    }
                    return fieldAccess;
                }
            });
        }
        return new TrimResult(r, mapping);
    }

    public TrimResult trimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        if (rel.getInputs().isEmpty()) {
            return this.result(rel, Mappings.createIdentity(rel.getRowType().getFieldCount()));
        }
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(rel.getInputs().size());
        for (RelNode input : rel.getInputs()) {
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(input.getRowType().getFieldCount());
            TrimResult trimResult = this.dispatchTrimFields(input, inputFieldsUsed, extraFields);
            if (!((Mapping)trimResult.right).isIdentity()) {
                throw new IllegalArgumentException("Expected identity mapping after processing RelNode " + input + "; but got " + trimResult.right);
            }
            newInputs.add((RelNode)trimResult.left);
        }
        RelNode newRel = rel.copy(rel.getTraitSet(), newInputs);
        return this.result(newRel, Mappings.createIdentity(newRel.getRowType().getFieldCount()), rel);
    }

    public TrimResult trimFields(Calc calc, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RexProgram rexProgram = calc.getProgram();
        List<RexNode> projs = Util.transform(rexProgram.getProjectList(), rexProgram::expandLocalRef);
        RexNode conditionExpr = rexProgram.getCondition() == null ? null : rexProgram.expandLocalRef(rexProgram.getCondition());
        RelDataType rowType = calc.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = calc.getInput();
        HashSet<RelDataTypeField> inputExtraFields = new HashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        for (Ord ord : Ord.zip(projs)) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept(inputFinder);
        }
        if (conditionExpr != null) {
            conditionExpr.accept(inputFinder);
        }
        ImmutableBitSet inputFieldsUsed = inputFinder.build();
        TrimResult trimResult = this.trimChild(calc, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(calc, Mappings.createIdentity(fieldCount));
        }
        if (fieldsUsed.cardinality() == 0 && rexProgram.getCondition() == null) {
            return this.dummyProject(fieldCount, newInput);
        }
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        for (Ord ord : Ord.zip(projs)) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjects.size());
            RexNode newProjectExpr = ((RexNode)ord.e).accept(shuttle);
            newProjects.add(newProjectExpr);
        }
        RelDataType newRowType = RelOptUtil.permute(calc.getCluster().getTypeFactory(), rowType, mapping);
        RelNode newInputRelNode = this.relBuilder.push(newInput).build();
        RexNode newConditionExpr = null;
        if (conditionExpr != null) {
            newConditionExpr = conditionExpr.accept(shuttle);
        }
        RexProgram newRexProgram = RexProgram.create(newInputRelNode.getRowType(), newProjects, newConditionExpr, newRowType.getFieldNames(), newInputRelNode.getCluster().getRexBuilder());
        Calc newCalc = calc.copy(calc.getTraitSet(), newInputRelNode, newRexProgram);
        return this.result(newCalc, mapping, calc);
    }

    private boolean inputContainsSubQueryTables(Project project, RelNode input) {
        InputTablesVisitor inputSubQueryTablesCollector = new InputTablesVisitor();
        RexUtil.apply((RexVisitor<Void>)inputSubQueryTablesCollector, project.getProjects(), null);
        Set<List<String>> subQueryTables = inputSubQueryTablesCollector.tables();
        assert (subQueryTables.isEmpty() || subQueryTables.size() == 1) : "unexpected different tables in subquery: " + subQueryTables;
        TableScanCollector inputTablesCollector = new TableScanCollector();
        input.accept(inputTablesCollector);
        Set<List<String>> inputTables = inputTablesCollector.tables();
        if (!subQueryTables.isEmpty()) {
            for (List<String> t : inputTables) {
                if (!t.equals(Iterables.getOnlyElement(subQueryTables))) continue;
                return true;
            }
        }
        return false;
    }

    public TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = project.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = project.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        List<RexSubQuery> subQueries = RexUtil.SubQueryCollector.collect(project);
        Set<CorrelationId> correlationIds = RelOptUtil.getVariablesUsed(subQueries);
        boolean subQueryLookUp = !correlationIds.isEmpty() && this.inputContainsSubQueryTables(project, input);
        RelOptUtil.SubQueryAwareInputFinder inputFinder = new RelOptUtil.SubQueryAwareInputFinder(inputExtraFields, subQueryLookUp);
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept(inputFinder);
        }
        ImmutableBitSet requiredColumns = ImmutableBitSet.of();
        if (!correlationIds.isEmpty()) {
            assert (correlationIds.size() == 1);
            requiredColumns = RelOptUtil.correlationColumns(correlationIds.iterator().next(), project);
        }
        ImmutableBitSet finderFields = inputFinder.build();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.builder().addAll(requiredColumns).addAll(finderFields).build();
        TrimResult trimResult = this.trimChild(project, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(project, Mappings.createIdentity(fieldCount));
        }
        if (fieldsUsed.cardinality() == 0) {
            return this.dummyProject(fieldCount, newInput, project);
        }
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjects.size());
            RexNode newProjectExpr = ((RexNode)ord.e).accept(shuttle);
            if (newProjectExpr instanceof RexSubQuery && newProjectExpr.getKind() == SqlKind.SCALAR_QUERY && !correlationIds.isEmpty()) {
                newProjectExpr = this.changeCorrelateReferences((RexSubQuery)newProjectExpr, (CorrelationId)Iterables.getOnlyElement(correlationIds), newInput.getRowType(), inputMapping);
            }
            newProjects.add(newProjectExpr);
        }
        RelDataType newRowType = RelOptUtil.permute(project.getCluster().getTypeFactory(), rowType, mapping);
        this.relBuilder.push(newInput);
        this.relBuilder.project(newProjects, newRowType.getFieldNames());
        RelNode newProject = this.relBuilder.build();
        return this.result(newProject, mapping, project);
    }

    private RexNode changeCorrelateReferences(RexSubQuery node, CorrelationId corrId, RelDataType rowType, Mapping inputMapping) {
        assert (node.getKind() == SqlKind.SCALAR_QUERY) : "Expected a SCALAR_QUERY, found " + (Object)((Object)node.getKind());
        RelNode subQuery = node.rel;
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RexCorrelVariableMapShuttle rexVisitor = new RexCorrelVariableMapShuttle(corrId, rowType, inputMapping, rexBuilder);
        RelNode newSubQuery = subQuery.accept(new RexRewritingRelShuttle(rexVisitor));
        return RexSubQuery.scalar(newSubQuery);
    }

    protected TrimResult dummyProject(int fieldCount, RelNode input) {
        return this.dummyProject(fieldCount, input, null);
    }

    protected TrimResult dummyProject(int fieldCount, RelNode input, @Nullable RelNode originalRelNode) {
        RelOptCluster cluster = input.getCluster();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, 1);
        if (input.getRowType().getFieldCount() == 1) {
            return this.result(input, mapping);
        }
        RexLiteral expr = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO);
        this.relBuilder.push(input);
        this.relBuilder.project((Iterable<? extends RexNode>)ImmutableList.of((Object)expr), (Iterable<? extends String>)ImmutableList.of((Object)"DUMMY"));
        RelNode newProject = this.relBuilder.build();
        if (originalRelNode != null) {
            newProject = RelOptUtil.propagateRelHints(originalRelNode, newProject);
        }
        return this.result(newProject, mapping);
    }

    public TrimResult trimFields(Filter filter, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = filter.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = filter.getCondition();
        RelNode input = filter.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields, fieldsUsed);
        conditionExpr.accept(inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.build();
        TrimResult trimResult = this.trimChild(filter, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(filter, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        this.relBuilder.push(newInput).filter(filter.getVariablesSet(), newConditionExpr);
        return this.result(this.relBuilder.build(), inputMapping, filter);
    }

    public TrimResult trimFields(Sort sort, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sort, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(sort, Mappings.createIdentity(fieldCount));
        }
        this.relBuilder.push(newInput);
        ImmutableList<RexNode> fields = this.relBuilder.fields(RexUtil.apply((Mappings.TargetMapping)inputMapping, collation));
        this.relBuilder.sortLimit(sort.offset, sort.fetch, (Iterable<? extends RexNode>)fields);
        return this.result(this.relBuilder.build(), inputMapping, sort);
    }

    public TrimResult trimFields(Exchange exchange, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = exchange.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelDistribution distribution = exchange.getDistribution();
        RelNode input = exchange.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (int keyIndex : distribution.getKeys()) {
            inputFieldsUsed.set(keyIndex);
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(exchange, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(exchange, Mappings.createIdentity(fieldCount));
        }
        this.relBuilder.push(newInput);
        RelDistribution newDistribution = distribution.apply(inputMapping);
        this.relBuilder.exchange(newDistribution);
        return this.result(this.relBuilder.build(), inputMapping, exchange);
    }

    public TrimResult trimFields(SortExchange sortExchange, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sortExchange.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sortExchange.getCollation();
        RelDistribution distribution = sortExchange.getDistribution();
        RelNode input = sortExchange.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Iterator<Object> iterator = distribution.getKeys().iterator();
        while (iterator.hasNext()) {
            int keyIndex = (Integer)iterator.next();
            inputFieldsUsed.set(keyIndex);
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sortExchange, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(sortExchange, Mappings.createIdentity(fieldCount));
        }
        this.relBuilder.push(newInput);
        RelCollation newCollation = RexUtil.apply((Mappings.TargetMapping)inputMapping, collation);
        RelDistribution newDistribution = distribution.apply(inputMapping);
        this.relBuilder.sortExchange(newDistribution, newCollation);
        return this.result(this.relBuilder.build(), inputMapping, sortExchange);
    }

    public TrimResult trimFields(Join join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getSystemFieldList().size() + join.getLeft().getRowType().getFieldCount() + join.getRight().getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        RexNode matchConditionExpr = join instanceof AsofJoin ? ((AsofJoin)join).getMatchCondition() : null;
        int systemFieldCount = join.getSystemFieldList().size();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields, fieldsUsed);
        conditionExpr.accept(inputFinder);
        if (matchConditionExpr != null) {
            matchConditionExpr.accept(inputFinder);
        }
        ImmutableBitSet fieldsUsedPlus = inputFinder.build();
        int systemFieldUsedCount = 0;
        for (int i = 0; i < systemFieldCount; ++i) {
            if (!fieldsUsed.get(i)) continue;
            ++systemFieldUsedCount;
        }
        int newSystemFieldCount = systemFieldUsedCount == 0 ? 0 : systemFieldCount;
        int offset = systemFieldCount;
        int changeCount = 0;
        int newFieldCount = newSystemFieldCount;
        ArrayList<Object> newInputs = new ArrayList<Object>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        ArrayList<Integer> inputExtraFieldCounts = new ArrayList<Integer>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            for (int bit : fieldsUsedPlus) {
                if (bit < offset || bit >= offset + inputFieldCount) continue;
                inputFieldsUsed.set(bit - offset);
            }
            inputFieldsUsed.set(0, newSystemFieldCount);
            Set<RelDataTypeField> inputExtraFields = RelDataTypeImpl.extra(inputRowType) == null ? Collections.emptySet() : combinedInputExtraFields;
            inputExtraFieldCounts.add(inputExtraFields.size());
            TrimResult trimResult = this.trimChild(join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add(trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount() + inputExtraFields.size();
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, newFieldCount);
        for (int i = 0; i < newSystemFieldCount; ++i) {
            mapping.set(i, i);
        }
        offset = systemFieldCount;
        int newOffset = newSystemFieldCount;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount() + (Integer)inputExtraFieldCounts.get(i);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return this.result(join, Mappings.createIdentity(join.getRowType().getFieldCount()));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1));
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        RexNode newMatchConditionExpr = matchConditionExpr != null ? matchConditionExpr.accept(shuttle) : null;
        this.relBuilder.push((RelNode)newInputs.get(0));
        this.relBuilder.push((RelNode)newInputs.get(1));
        switch (join.getJoinType()) {
            case SEMI: 
            case ANTI: {
                if (join.getJoinType() == JoinRelType.SEMI) {
                    this.relBuilder.semiJoin(newConditionExpr);
                } else {
                    this.relBuilder.antiJoin(newConditionExpr);
                }
                Mapping inputMapping = (Mapping)inputMappings.get(0);
                mapping = Mappings.create(MappingType.INVERSE_SURJECTION, join.getRowType().getFieldCount(), newSystemFieldCount + inputMapping.getTargetCount());
                for (int i = 0; i < newSystemFieldCount; ++i) {
                    mapping.set(i, i);
                }
                offset = systemFieldCount;
                newOffset = newSystemFieldCount;
                for (IntPair pair : inputMapping) {
                    mapping.set(pair.source + offset, pair.target + newOffset);
                }
                break;
            }
            case ASOF: 
            case LEFT_ASOF: {
                this.relBuilder.asofJoin(join.getJoinType(), newConditionExpr, Objects.requireNonNull(newMatchConditionExpr, "newMatchConditionExpr"));
                break;
            }
            default: {
                this.relBuilder.join(join.getJoinType(), newConditionExpr);
            }
        }
        return this.result(this.relBuilder.build(), mapping, join);
    }

    public TrimResult trimFields(SetOp setOp, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = setOp.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (setOp.kind != SqlKind.UNION || !setOp.all) {
            return this.trimFields((RelNode)setOp, fieldsUsed, extraFields);
        }
        int changeCount = 0;
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.of(rowType.getFieldCount() - 1);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        for (RelNode input : setOp.getInputs()) {
            TrimResult trimResult = this.trimChild(setOp, input, fieldsUsed, extraFields);
            Mapping remaining = Mappings.divide(mapping, (Mapping)trimResult.right);
            this.relBuilder.push((RelNode)trimResult.left);
            this.relBuilder.permute(remaining);
            if (input == this.relBuilder.peek()) continue;
            ++changeCount;
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            for (RelNode input : setOp.getInputs()) {
                this.relBuilder.build();
            }
            return this.result(setOp, mapping);
        }
        switch (setOp.kind) {
            case UNION: {
                this.relBuilder.union(setOp.all, setOp.getInputs().size());
                break;
            }
            case INTERSECT: {
                this.relBuilder.intersect(setOp.all, setOp.getInputs().size());
                break;
            }
            case EXCEPT: {
                assert (setOp.getInputs().size() == 2);
                this.relBuilder.minus(setOp.all);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown setOp " + setOp));
            }
        }
        return this.result(this.relBuilder.build(), mapping, setOp);
    }

    public TrimResult trimFields(Aggregate aggregate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = aggregate.getRowType();
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        int aggCallIndex = aggregate.getGroupCount();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(aggCallIndex)) {
                inputFieldsUsed.addAll(aggCall.getArgList());
                if (aggCall.filterArg >= 0) {
                    inputFieldsUsed.set(aggCall.filterArg);
                }
                if (aggCall.distinctKeys != null) {
                    inputFieldsUsed.addAll(aggCall.distinctKeys);
                }
                inputFieldsUsed.addAll(RelCollations.ordinals(aggCall.collation));
            }
            ++aggCallIndex;
        }
        RelNode input = aggregate.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(aggregate, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        int groupCount = aggregate.getGroupSet().cardinality();
        fieldsUsed = fieldsUsed.union(ImmutableBitSet.range(groupCount));
        if (input == newInput && fieldsUsed.equals(ImmutableBitSet.range(rowType.getFieldCount()))) {
            return this.result(aggregate, Mappings.createIdentity(rowType.getFieldCount()));
        }
        int j = groupCount;
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, rowType.getFieldCount(), groupCount + usedAggCallCount);
        ImmutableBitSet newGroupSet = Mappings.apply(inputMapping, aggregate.getGroupSet());
        ImmutableList newGroupSets = ImmutableList.copyOf(Util.transform(aggregate.getGroupSets(), input1 -> Mappings.apply(inputMapping, input1)));
        for (j = 0; j < groupCount; ++j) {
            mapping.set(j, j);
        }
        this.relBuilder.push(newInput);
        ArrayList<RelBuilder.AggCall> newAggCallList = new ArrayList<RelBuilder.AggCall>();
        j = groupCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                mapping.set(j, groupCount + newAggCallList.size());
                newAggCallList.add(this.relBuilder.aggregateCall(aggCall, inputMapping));
            }
            ++j;
        }
        if (newAggCallList.isEmpty() && newGroupSet.isEmpty()) {
            mapping = Mappings.create(MappingType.INVERSE_SURJECTION, mapping.getSourceCount(), 1);
            newAggCallList.add(this.relBuilder.count(false, "DUMMY", new RexNode[0]));
        }
        RelBuilder.GroupKey groupKey = this.relBuilder.groupKey(newGroupSet, (Iterable<? extends ImmutableBitSet>)newGroupSets);
        this.relBuilder.aggregate(groupKey, (Iterable<? extends RelBuilder.AggCall>)newAggCallList);
        RelNode newAggregate = this.relBuilder.build();
        return this.result(newAggregate, mapping, aggregate);
    }

    public TrimResult trimFields(LogicalTableModify modifier, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        RelDataType rowType = modifier.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = modifier.getInput();
        int inputFieldCount = input.getRowType().getFieldCount();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(modifier, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (!inputMapping.isIdentity()) {
            throw new AssertionError((Object)("Expected identity mapping, got " + inputMapping));
        }
        RelNode newModifier = modifier;
        if (newInput != input) {
            newModifier = modifier.copy(modifier.getTraitSet(), (List)Collections.singletonList(newInput));
        }
        assert (newModifier.getClass() == modifier.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return this.result(newModifier, mapping, modifier);
    }

    public TrimResult trimFields(LogicalTableFunctionScan tabFun, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<Object> newInputs = new ArrayList<Object>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            TrimResult trimResult = this.trimChildRestore(tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add(trimResult.left);
        }
        TableFunctionScan newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs, tabFun.getCall(), tabFun.getElementType(), tabFun.getRowType(), (Set)tabFun.getColumnMappings());
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return this.result(newTabFun, mapping, tabFun);
    }

    public TrimResult trimFields(LogicalValues values, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = values.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.range(fieldCount - 1, fieldCount);
        }
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount))) {
            Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
            return this.result(values, mapping);
        }
        ImmutableList.Builder newTuples = ImmutableList.builder();
        for (ImmutableList tuple : values.getTuples()) {
            ImmutableList.Builder newTuple = ImmutableList.builder();
            for (int field : fieldsUsed) {
                newTuple.add(tuple.get(field));
            }
            newTuples.add((Object)newTuple.build());
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        RelDataType newRowType = RelOptUtil.permute(values.getCluster().getTypeFactory(), rowType, mapping);
        LogicalValues newValues = LogicalValues.create(values.getCluster(), newRowType, (ImmutableList<ImmutableList<RexLiteral>>)newTuples.build());
        return this.result(newValues, mapping, values);
    }

    public TrimResult trimFields(Sample sample, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sample.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = sample.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sample, input, fieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(sample, Mappings.createIdentity(fieldCount));
        }
        RelNode newSample = sample.copy(sample.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newInput));
        return this.result(newSample, inputMapping, sample);
    }

    public TrimResult trimFields(Snapshot snapshot, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = snapshot.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = snapshot.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(snapshot, input, fieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(snapshot, Mappings.createIdentity(fieldCount));
        }
        Snapshot newSnapshot = snapshot.copy(snapshot.getTraitSet(), newInput, snapshot.getPeriod());
        return this.result(newSnapshot, inputMapping, snapshot);
    }

    public TrimResult trimFields(LogicalCorrelate correlate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        if (!extraFields.isEmpty()) {
            return this.trimFields((RelNode)correlate, fieldsUsed, extraFields);
        }
        fieldsUsed = fieldsUsed.union(correlate.getRequiredColumns());
        ArrayList<Object> newInputs = new ArrayList<Object>();
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        int changeCount = 0;
        int offset = 0;
        for (RelNode input : correlate.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet currentInputFieldsUsed = fieldsUsed.intersect(ImmutableBitSet.range(offset, offset + inputFieldCount)).shift(-offset);
            TrimResult trimResult = this.dispatchTrimFields(input, currentInputFieldsUsed, extraFields);
            newInputs.add(trimResult.left);
            inputMappings.add((Mapping)trimResult.right);
            offset += inputFieldCount;
            if (trimResult.left == input) continue;
            ++changeCount;
        }
        if (changeCount == 0) {
            return this.result(correlate, Mappings.createIdentity(correlate.getRowType().getFieldCount()));
        }
        Mapping mapping = Mappings.concatenateMappings(inputMappings);
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelNode newLeft = (RelNode)newInputs.get(0);
        RexCorrelVariableMapShuttle rexVisitor = new RexCorrelVariableMapShuttle(correlate.getCorrelationId(), newLeft.getRowType(), mapping, rexBuilder);
        RelNode newRight = ((RelNode)newInputs.get(1)).accept(new RexRewritingRelShuttle(rexVisitor));
        LogicalCorrelate newCorrelate = correlate.copy(correlate.getTraitSet(), newLeft, newRight, correlate.getCorrelationId(), correlate.getRequiredColumns().permute(mapping), correlate.getJoinType());
        return this.result(newCorrelate, mapping);
    }

    protected Mapping createMapping(ImmutableBitSet fieldsUsed, int fieldCount) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        int i = 0;
        for (int field : fieldsUsed) {
            mapping.set(field, i++);
        }
        return mapping;
    }

    public TrimResult trimFields(TableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = tableAccessRel.getRowType().getFieldCount();
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)tableAccessRel, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = tableAccessRel.project(fieldsUsed, extraFields, this.relBuilder);
        if (fieldsUsed.cardinality() == 0) {
            Project project;
            RelNode input = newTableAccessRel;
            if (input instanceof Project && (project = (Project)input).getRowType().getFieldCount() == 0) {
                input = project.getInput();
            }
            return this.dummyProject(fieldCount, input);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return this.result(newTableAccessRel, mapping, tableAccessRel);
    }

    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super(left, right);
            assert (right.getTargetCount() == left.getRowType().getFieldCount()) : "rowType: " + left.getRowType() + ", mapping: " + right;
        }
    }

    static class RexCorrelVariableMapShuttle
    extends RexShuttle {
        private final CorrelationId correlationId;
        private final Mapping mapping;
        private final RelDataType newCorrelRowType;
        private final RexBuilder rexBuilder;

        RexCorrelVariableMapShuttle(CorrelationId correlationId, RelDataType newCorrelRowType, Mapping mapping, RexBuilder rexBuilder) {
            this.correlationId = correlationId;
            this.newCorrelRowType = newCorrelRowType;
            this.mapping = mapping;
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) {
                RexCorrelVariable referenceExpr = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                if (referenceExpr.id.equals(this.correlationId)) {
                    int oldIndex = fieldAccess.getField().getIndex();
                    int newIndex = this.mapping.getTarget(oldIndex);
                    if (newIndex == oldIndex) {
                        return super.visitFieldAccess(fieldAccess);
                    }
                    RexNode newCorrel = this.rexBuilder.makeCorrel(this.newCorrelRowType, referenceExpr.id);
                    return this.rexBuilder.makeFieldAccess(newCorrel, newIndex);
                }
            }
            return super.visitFieldAccess(fieldAccess);
        }
    }

    private static class InputTablesVisitor
    extends RexVisitorImpl<Void> {
        private ImmutableSet.Builder<List<String>> builder = ImmutableSet.builder();

        protected InputTablesVisitor() {
            super(false);
        }

        Set<List<String>> tables() {
            return this.builder.build();
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            if (subQuery.getKind() == SqlKind.SCALAR_QUERY) {
                subQuery.rel.accept(new RelHomogeneousShuttle(){

                    @Override
                    public RelNode visit(TableScan scan) {
                        builder.add(scan.getTable().getQualifiedName());
                        return super.visit(scan);
                    }
                });
            }
            return null;
        }
    }

    private static class TableScanCollector
    extends RelHomogeneousShuttle {
        private ImmutableSet.Builder<List<String>> builder = ImmutableSet.builder();

        private TableScanCollector() {
        }

        Set<List<String>> tables() {
            return this.builder.build();
        }

        @Override
        public RelNode visit(TableScan scan) {
            this.builder.add(scan.getTable().getQualifiedName());
            return super.visit(scan);
        }
    }
}

