/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.control;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.control.FlowControl;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class IfStatement
implements FlowControl {
    private final String comment;
    private final BytecodeBlock condition = new BytecodeBlock();
    private final BytecodeBlock ifTrue = new BytecodeBlock();
    private final BytecodeBlock ifFalse = new BytecodeBlock();
    private final LabelNode falseLabel = new LabelNode("false");
    private final LabelNode outLabel = new LabelNode("out");

    public IfStatement() {
        this.comment = null;
    }

    public IfStatement(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeBlock condition() {
        return this.condition;
    }

    public IfStatement condition(BytecodeNode node) {
        BytecodeUtils.checkState(this.condition.isEmpty(), "condition already set");
        this.condition.append(node);
        return this;
    }

    public BytecodeBlock ifTrue() {
        return this.ifTrue;
    }

    public IfStatement ifTrue(BytecodeNode node) {
        BytecodeUtils.checkState(this.ifTrue.isEmpty(), "ifTrue already set");
        this.ifTrue.append(node);
        return this;
    }

    public BytecodeBlock ifFalse() {
        return this.ifFalse;
    }

    public IfStatement ifFalse(BytecodeNode node) {
        BytecodeUtils.checkState(this.ifFalse.isEmpty(), "ifFalse already set");
        this.ifFalse.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        BytecodeUtils.checkState(!this.condition.isEmpty(), "IfStatement does not have a condition set");
        BytecodeUtils.checkState(!this.ifTrue.isEmpty() || !this.ifFalse.isEmpty(), "IfStatement does not have a true or false block set");
        BytecodeBlock block = new BytecodeBlock();
        block.append(new BytecodeBlock().setDescription("condition").append(this.condition));
        block.ifFalseGoto(this.falseLabel);
        if (!this.ifTrue.isEmpty()) {
            block.append(new BytecodeBlock().setDescription("ifTrue").append(this.ifTrue));
        }
        if (!this.ifFalse.isEmpty()) {
            block.gotoLabel(this.outLabel);
            block.visitLabel(this.falseLabel);
            block.append(new BytecodeBlock().setDescription("ifFalse").append(this.ifFalse));
            block.visitLabel(this.outLabel);
        } else {
            block.visitLabel(this.falseLabel);
        }
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.condition, this.ifTrue, this.ifFalse);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitIf(parent, this);
    }
}

