/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.debug;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.debug.DebugNode;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LineNumberNode
implements DebugNode {
    private final int lineNumber;
    private final LabelNode label = new LabelNode();

    public LineNumberNode(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        if (generationContext.updateLineNumber(this.lineNumber)) {
            this.label.accept(visitor, generationContext);
            visitor.visitLineNumber(this.lineNumber, this.label.getLabel());
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{line=" + this.lineNumber + "}";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitLineNumber(parent, this);
    }
}

