/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.concurrent.Executor;
import org.apache.ignite.internal.table.PublicApiThreadingKeyValueView;
import org.apache.ignite.internal.table.PublicApiThreadingRecordView;
import org.apache.ignite.internal.table.partition.PublicApiThreadingPartitionManager;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.PartitionManager;

public class PublicApiThreadingTable
implements Table,
Wrapper {
    private final Table table;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingTable(Table table, Executor asyncContinuationExecutor) {
        this.table = table;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public QualifiedName qualifiedName() {
        return this.table.qualifiedName();
    }

    public PartitionManager partitionManager() {
        return new PublicApiThreadingPartitionManager(this.table.partitionManager(), this.asyncContinuationExecutor);
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return new PublicApiThreadingRecordView(this.table.recordView(recMapper), this.asyncContinuationExecutor);
    }

    public RecordView<Tuple> recordView() {
        return new PublicApiThreadingRecordView<Tuple>(this.table.recordView(), this.asyncContinuationExecutor);
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new PublicApiThreadingKeyValueView(this.table.keyValueView(keyMapper, valMapper), this.asyncContinuationExecutor);
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new PublicApiThreadingKeyValueView<Tuple, Tuple>(this.table.keyValueView(), this.asyncContinuationExecutor);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.table);
    }
}

