/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

class AwaitTasksCompletionExecutor
implements Executor {
    private final Executor executor;
    private final Runnable updateHeartbeat;
    private List<CompletableFuture<?>> pendingTaskFutures = new ArrayList();

    AwaitTasksCompletionExecutor(Executor executor, Runnable updateHeartbeat) {
        this.executor = executor;
        this.updateHeartbeat = updateHeartbeat;
    }

    @Override
    public void execute(Runnable command) {
        CompletableFuture future = new CompletableFuture();
        CompletionStage heartbeatFuture = future.whenComplete((o, throwable) -> this.updateHeartbeat.run());
        this.pendingTaskFutures.add((CompletableFuture<?>)heartbeatFuture);
        this.executor.execute(() -> {
            try {
                command.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
    }

    void awaitPendingTasksFinished() {
        List<CompletableFuture<?>> futures = this.pendingTaskFutures;
        if (!futures.isEmpty()) {
            this.pendingTaskFutures = new ArrayList();
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        }
    }
}

