/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.configuration;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.PublicName;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.Range;

@Config
public class ReplicationConfigurationSchema {
    public static final long DEFAULT_IDLE_SAFE_TIME_PROP_DURATION = TimeUnit.SECONDS.toMillis(1L);
    public static final int DEFAULT_BATCH_SIZE_BYTES = 8192;
    @Value(hasDefault=true)
    @Range(min=0L)
    @PublicName(legacyNames={"idleSafeTimePropagationDuration"})
    public long idleSafeTimePropagationDurationMillis = DEFAULT_IDLE_SAFE_TIME_PROP_DURATION;
    @Value(hasDefault=true)
    @Range(min=1000L)
    @PublicName(legacyNames={"rpcTimeout"})
    public long rpcTimeoutMillis = TimeUnit.SECONDS.toMillis(60L);
    @Value(hasDefault=true)
    @Range(min=5000L)
    @PublicName(legacyNames={"leaseAgreementAcceptanceTimeLimit"})
    public long leaseAgreementAcceptanceTimeLimitMillis = 120000L;
    @Value(hasDefault=true)
    @Range(min=2000L, max=120000L)
    @PublicName(legacyNames={"leaseExpirationInterval"})
    public long leaseExpirationIntervalMillis = 5000L;
    @Value(hasDefault=true)
    @Range(max=10000L)
    @PublicName(legacyNames={"replicaOperationRetryInterval"})
    public int replicaOperationRetryIntervalMillis = 10;
    @Range(min=1L)
    @Value(hasDefault=true)
    public int batchSizeBytes = 8192;
}

