/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class Catalog {
    private final int version;
    private final int objectIdGen;
    private final long activationTimestamp;
    private final Map<String, CatalogSchemaDescriptor> schemasByName;
    private final Map<String, CatalogZoneDescriptor> zonesByName;
    @Nullable
    private final CatalogZoneDescriptor defaultZone;
    @IgniteToStringExclude
    private final Int2ObjectMap<CatalogSchemaDescriptor> schemasById;
    @IgniteToStringExclude
    private final Int2ObjectMap<CatalogTableDescriptor> tablesById;
    @IgniteToStringExclude
    private final Int2ObjectMap<CatalogIndexDescriptor> indexesById;
    @IgniteToStringExclude
    private final Int2ObjectMap<List<CatalogIndexDescriptor>> indexesByTableId;
    @IgniteToStringExclude
    private final Int2ObjectMap<CatalogZoneDescriptor> zonesById;
    @IgniteToStringExclude
    private final Int2ObjectMap<List<CatalogTableDescriptor>> tablesByZoneId;

    private static <T extends CatalogObjectDescriptor> Collector<T, ?, Map<String, T>> toMapByName() {
        return Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity());
    }

    private static <T extends CatalogObjectDescriptor> Collector<T, ?, Int2ObjectMap<T>> toMapById() {
        return Collectors.collectingAndThen(CollectionUtils.toIntMapCollector(CatalogObjectDescriptor::id, Function.identity()), Int2ObjectMaps::unmodifiable);
    }

    public Catalog(int version, long activationTimestamp, int objectIdGen, Collection<CatalogZoneDescriptor> zones, Collection<CatalogSchemaDescriptor> schemas, @Nullable Integer defaultZoneId) {
        this.version = version;
        this.activationTimestamp = activationTimestamp;
        this.objectIdGen = objectIdGen;
        Objects.requireNonNull(schemas, "schemas");
        Objects.requireNonNull(zones, "zones");
        this.schemasByName = schemas.stream().collect(Catalog.toMapByName());
        this.zonesByName = zones.stream().collect(Catalog.toMapByName());
        this.schemasById = schemas.stream().collect(Catalog.toMapById());
        this.tablesById = schemas.stream().flatMap(s -> Arrays.stream(s.tables())).collect(Catalog.toMapById());
        this.indexesById = schemas.stream().flatMap(s -> Arrays.stream(s.indexes())).collect(Catalog.toMapById());
        this.indexesByTableId = Int2ObjectMaps.unmodifiable(Catalog.toIndexesByTableId(schemas));
        this.zonesById = zones.stream().collect(Catalog.toMapById());
        this.tablesByZoneId = Int2ObjectMaps.unmodifiable(Catalog.toTablesByZoneId(schemas));
        if (defaultZoneId != null) {
            this.defaultZone = (CatalogZoneDescriptor)this.zonesById.get(defaultZoneId.intValue());
            if (this.defaultZone == null) {
                throw new IllegalStateException("The default zone was not found among the provided zones [id=" + defaultZoneId + "]");
            }
        } else {
            this.defaultZone = null;
        }
    }

    public int version() {
        return this.version;
    }

    public long time() {
        return this.activationTimestamp;
    }

    public int objectIdGenState() {
        return this.objectIdGen;
    }

    @Nullable
    public CatalogSchemaDescriptor schema(String name) {
        return this.schemasByName.get(name);
    }

    @Nullable
    public CatalogSchemaDescriptor schema(int schemaId) {
        return (CatalogSchemaDescriptor)this.schemasById.get(schemaId);
    }

    public Collection<CatalogSchemaDescriptor> schemas() {
        return this.schemasByName.values();
    }

    @Nullable
    public CatalogTableDescriptor table(int tableId) {
        return (CatalogTableDescriptor)this.tablesById.get(tableId);
    }

    @Nullable
    public CatalogTableDescriptor table(String schemaName, String tableName) {
        CatalogSchemaDescriptor schema = this.schema(schemaName);
        return schema == null ? null : schema.table(tableName);
    }

    public Collection<CatalogTableDescriptor> tables() {
        return this.tablesById.values();
    }

    public Collection<CatalogTableDescriptor> tables(int zoneId) {
        return (Collection)this.tablesByZoneId.getOrDefault(zoneId, List.of());
    }

    @Nullable
    public CatalogIndexDescriptor aliveIndex(String schemaName, String indexName) {
        CatalogSchemaDescriptor schema = this.schema(schemaName);
        return schema == null ? null : schema.aliveIndex(indexName);
    }

    @Nullable
    public CatalogIndexDescriptor index(int indexId) {
        return (CatalogIndexDescriptor)this.indexesById.get(indexId);
    }

    public Collection<CatalogIndexDescriptor> indexes() {
        return this.indexesById.values();
    }

    public List<CatalogIndexDescriptor> indexes(int tableId) {
        return (List)this.indexesByTableId.getOrDefault(tableId, List.of());
    }

    @Nullable
    public CatalogZoneDescriptor zone(String name) {
        return this.zonesByName.get(name);
    }

    @Nullable
    public CatalogZoneDescriptor zone(int zoneId) {
        return (CatalogZoneDescriptor)this.zonesById.get(zoneId);
    }

    public Collection<CatalogZoneDescriptor> zones() {
        return this.zonesByName.values();
    }

    @Nullable
    public CatalogZoneDescriptor defaultZone() {
        return this.defaultZone;
    }

    public String toString() {
        return S.toString(this);
    }

    private static Int2ObjectMap<List<CatalogIndexDescriptor>> toIndexesByTableId(Collection<CatalogSchemaDescriptor> schemas) {
        Int2ObjectOpenHashMap indexesByTableId = new Int2ObjectOpenHashMap();
        for (CatalogSchemaDescriptor schema : schemas) {
            for (CatalogIndexDescriptor index : schema.indexes()) {
                ((List)indexesByTableId.computeIfAbsent(index.tableId(), indexes -> new ArrayList())).add(index);
            }
        }
        for (List indexes2 : indexesByTableId.values()) {
            indexes2.sort(Comparator.comparingInt(CatalogObjectDescriptor::id));
        }
        for (Int2ObjectMap.Entry entry : indexesByTableId.int2ObjectEntrySet()) {
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        return indexesByTableId;
    }

    private static Int2ObjectMap<List<CatalogTableDescriptor>> toTablesByZoneId(Collection<CatalogSchemaDescriptor> schemas) {
        Int2ObjectOpenHashMap tablesByZoneId = new Int2ObjectOpenHashMap();
        for (CatalogSchemaDescriptor schema : schemas) {
            for (CatalogTableDescriptor table : schema.tables()) {
                ((List)tablesByZoneId.computeIfAbsent(table.zoneId(), tables -> new ArrayList())).add(table);
            }
        }
        for (Int2ObjectMap.Entry entry : tablesByZoneId.int2ObjectEntrySet()) {
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        return tablesByZoneId;
    }
}

