/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite3.internal.storage.BinaryRowAndRowId;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.internal.util.Cursor;

class BuildIndexRowVersionChooser {
    private final PartitionDataStorage storage;
    private final long createIndexActivationTs;
    private final long startBuildingIndexActivationTs;

    BuildIndexRowVersionChooser(PartitionDataStorage storage, long createIndexActivationTs, long startBuildingIndexActivationTs) {
        this.storage = storage;
        this.createIndexActivationTs = createIndexActivationTs;
        this.startBuildingIndexActivationTs = startBuildingIndexActivationTs;
    }

    List<BinaryRowAndRowId> chooseForBuildIndex(RowId rowId) {
        try (Cursor<ReadResult> rowVersionCursor = this.storage.scanVersions(rowId);){
            ArrayList<BinaryRowAndRowId> result = new ArrayList<BinaryRowAndRowId>();
            boolean takenLatestVersionOfWriteCommitted = false;
            for (ReadResult readResult : rowVersionCursor) {
                if (readResult.isEmpty()) continue;
                if (readResult.isWriteIntent()) {
                    if (BuildIndexRowVersionChooser.beginTs(readResult) >= this.createIndexActivationTs) {
                        continue;
                    }
                } else {
                    if (BuildIndexRowVersionChooser.commitTs(readResult) > this.startBuildingIndexActivationTs) continue;
                    takenLatestVersionOfWriteCommitted = true;
                }
                result.add(new BinaryRowAndRowId(readResult.binaryRow(), rowId));
                if (!takenLatestVersionOfWriteCommitted) continue;
                break;
            }
            ArrayList<BinaryRowAndRowId> arrayList = result;
            return arrayList;
        }
    }

    private static long beginTs(ReadResult readResult) {
        return TransactionIds.beginTimestamp(readResult.transactionId()).longValue();
    }

    private static long commitTs(ReadResult readResult) {
        return readResult.commitTimestamp().longValue();
    }
}

