/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheClearAllRunnable<K, V>
implements Runnable {
    protected final GridCacheAdapter<K, V> cache;
    protected final GridCacheVersion obsoleteVer;
    protected final int id;
    protected final int totalCnt;
    protected final boolean readers;
    protected final GridCacheContext<K, V> ctx;
    protected final IgniteLogger log;

    public GridCacheClearAllRunnable(GridCacheAdapter<K, V> cache, GridCacheVersion obsoleteVer, int id, int totalCnt, boolean readers) {
        assert (cache != null);
        assert (obsoleteVer != null);
        assert (id >= 0);
        assert (totalCnt > 0);
        assert (id < totalCnt);
        this.cache = cache;
        this.obsoleteVer = obsoleteVer;
        this.id = id;
        this.totalCnt = totalCnt;
        this.readers = readers;
        this.ctx = cache.context();
        this.log = this.ctx.logger(this.getClass());
    }

    @Override
    public void run() {
        for (GridCacheEntryEx gridCacheEntryEx : this.cache.entries()) {
            this.clearEntry(gridCacheEntryEx);
        }
        if (!this.ctx.isNear() && this.id == 0) {
            this.ctx.offheap().clearCache(this.ctx, this.readers);
        }
    }

    protected void clearEntry(GridCacheEntryEx e) {
        this.ctx.shared().database().checkpointReadLock();
        try {
            e.clear(this.obsoleteVer, this.readers);
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to clearLocally entry from cache (will continue to clearLocally other entries): " + e, ex);
        }
        finally {
            this.ctx.shared().database().checkpointReadUnlock();
        }
    }

    protected boolean owns(KeyCacheObject key) {
        assert (key != null);
        return this.totalCnt == 1 || key.hashCode() % this.totalCnt == this.id;
    }

    public int id() {
        return this.id;
    }

    public int totalCount() {
        return this.totalCnt;
    }

    public boolean readers() {
        return this.readers;
    }

    public String toString() {
        return S.toString(GridCacheClearAllRunnable.class, this);
    }
}

