/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
class GridCacheLogger
implements IgniteLogger,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static ThreadLocal<IgniteBiTuple<String, GridCacheContext>> stash = new ThreadLocal<IgniteBiTuple<String, GridCacheContext>>(){

        @Override
        protected IgniteBiTuple<String, GridCacheContext> initialValue() {
            return new IgniteBiTuple<String, GridCacheContext>();
        }
    };
    private IgniteLogger log;
    private GridCacheContext<?, ?> cctx;
    private String cacheName;
    private String ctgr;

    GridCacheLogger(GridCacheContext<?, ?> cctx, String ctgr) {
        assert (cctx != null);
        assert (ctgr != null);
        this.cctx = cctx;
        this.ctgr = ctgr;
        this.cacheName = '<' + cctx.name() + "> ";
        this.log = cctx.kernalContext().log(ctgr);
    }

    public GridCacheLogger() {
    }

    private String format(String msg) {
        return this.cacheName + msg;
    }

    @Override
    public void debug(String msg) {
        this.log.debug(this.format(msg));
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        return new GridCacheLogger(this.cctx, ctgr.toString());
    }

    @Override
    public void trace(String msg) {
        this.log.trace(this.format(msg));
    }

    @Override
    public void info(String msg) {
        this.log.info(this.format(msg));
    }

    @Override
    public void warning(String msg) {
        this.log.warning(this.format(msg));
    }

    @Override
    public void warning(String msg, @Nullable Throwable e) {
        this.log.warning(this.format(msg), e);
    }

    @Override
    public void error(String msg) {
        this.log.error(this.format(msg));
    }

    @Override
    public void error(String msg, @Nullable Throwable e) {
        this.log.error(this.format(msg), e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isQuiet() {
        return this.log.isQuiet();
    }

    @Override
    @Nullable
    public String fileName() {
        return this.log.fileName();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.ctgr);
        out.writeObject(this.cctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<String, GridCacheContext> t = stash.get();
        t.set1(U.readString(in));
        t.set2((GridCacheContext)in.readObject());
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<String, GridCacheContext> t = stash.get();
            return t.get2().logger(t.get1());
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
    }

    public String toString() {
        return S.toString(GridCacheLogger.class, this);
    }
}

