/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtTxFinishRequest
extends GridDistributedTxFinishRequest {
    private static final long serialVersionUID = 0L;
    private UUID nearNodeId;
    private TransactionIsolation isolation;
    private int miniId;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> pendingVers;
    @GridToStringInclude
    @GridDirectCollection(value=Long.class)
    private GridLongList partUpdateCnt;
    private GridCacheVersion writeVer;
    private MvccSnapshot mvccSnapshot;
    @GridDirectCollection(value=PartitionUpdateCountersMessage.class)
    private Collection<PartitionUpdateCountersMessage> updCntrs;

    public GridDhtTxFinishRequest() {
    }

    public GridDhtTxFinishRequest(UUID nearNodeId, IgniteUuid futId, int miniId, @NotNull AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, long threadId, TransactionIsolation isolation, boolean commit, boolean invalidate, boolean sys, byte plc, boolean sysInvalidate, CacheWriteSynchronizationMode syncMode, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers, int txSize, @Nullable UUID subjId, int taskNameHash, boolean addDepInfo, boolean retVal, boolean waitRemoteTxs, MvccSnapshot mvccSnapshot, Collection<PartitionUpdateCountersMessage> updCntrs) {
        super(xidVer, futId, topVer, commitVer, threadId, commit, invalidate, sys, plc, syncMode, baseVer, committedVers, rolledbackVers, subjId, taskNameHash, txSize, addDepInfo);
        assert (miniId != 0);
        assert (nearNodeId != null);
        assert (isolation != null);
        this.pendingVers = pendingVers;
        this.nearNodeId = nearNodeId;
        this.isolation = isolation;
        this.miniId = miniId;
        this.mvccSnapshot = mvccSnapshot;
        this.updCntrs = updCntrs;
        this.needReturnValue(retVal);
        this.waitRemoteTransactions(waitRemoteTxs);
        this.systemInvalidate(sysInvalidate);
    }

    public GridDhtTxFinishRequest(UUID nearNodeId, IgniteUuid futId, int miniId, @NotNull AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, long threadId, TransactionIsolation isolation, boolean commit, boolean invalidate, boolean sys, byte plc, boolean sysInvalidate, CacheWriteSynchronizationMode syncMode, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers, int txSize, @Nullable UUID subjId, int taskNameHash, boolean addDepInfo, Collection<Long> updateIdxs, boolean retVal, boolean waitRemoteTxs, MvccSnapshot mvccSnapshot, Collection<PartitionUpdateCountersMessage> updCntrs) {
        this(nearNodeId, futId, miniId, topVer, xidVer, commitVer, threadId, isolation, commit, invalidate, sys, plc, sysInvalidate, syncMode, baseVer, committedVers, rolledbackVers, pendingVers, txSize, subjId, taskNameHash, addDepInfo, retVal, waitRemoteTxs, mvccSnapshot, updCntrs);
    }

    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public GridLongList partUpdateCounters() {
        return this.partUpdateCnt;
    }

    public int miniId() {
        return this.miniId;
    }

    public TransactionIsolation isolation() {
        return this.isolation;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public boolean isSystemInvalidate() {
        return this.isFlag(8);
    }

    private void systemInvalidate(boolean sysInvalidate) {
        this.setFlag(sysInvalidate, 8);
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public void writeVersion(GridCacheVersion writeVer) {
        this.writeVer = writeVer;
    }

    public boolean checkCommitted() {
        return this.isFlag(2);
    }

    public void checkCommitted(boolean checkCommitted) {
        this.setFlag(checkCommitted, 2);
    }

    public boolean waitRemoteTransactions() {
        return this.isFlag(1);
    }

    private void waitRemoteTransactions(boolean waitRemoteTxs) {
        this.setFlag(waitRemoteTxs, 1);
    }

    public boolean needReturnValue() {
        return this.isFlag(4);
    }

    public void needReturnValue(boolean retVal) {
        this.setFlag(retVal, 4);
    }

    public Collection<PartitionUpdateCountersMessage> updateCounters() {
        return this.updCntrs;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 22: {
                if (!writer.writeByte("isolation", this.isolation != null ? (byte)this.isolation.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeMessage("partUpdateCnt", this.partUpdateCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeCollection("pendingVers", this.pendingVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeCollection("updCntrs", this.updCntrs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 22: {
                byte isolationOrd = reader.readByte("isolation");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.isolation = TransactionIsolation.fromOrdinal(isolationOrd);
                reader.incrementState();
            }
            case 23: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.partUpdateCnt = (GridLongList)reader.readMessage("partUpdateCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.pendingVers = reader.readCollection("pendingVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.updCntrs = reader.readCollection("updCntrs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxFinishRequest.class);
    }

    @Override
    public short directType() {
        return 32;
    }

    @Override
    public byte fieldsCount() {
        return 30;
    }

    @Override
    public int partition() {
        return U.safeAbs(this.version().hashCode());
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxFinishRequest.class, this, super.toString());
    }
}

