/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.odbc.ClientMessage;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;

public class ClientListenerNioMessageParser
implements GridNioParser {
    static final int MSG_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    static final int READER_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private final IgniteLogger log;

    public ClientListenerNioMessageParser(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public Object decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        Message msg = (Message)ses.removeMeta(MSG_META_KEY);
        try {
            if (msg == null) {
                msg = new ClientMessage();
            }
            boolean finished = false;
            if (buf.hasRemaining()) {
                finished = msg.readFrom(buf, null);
            }
            if (finished) {
                return msg;
            }
            ses.addMeta(MSG_META_KEY, msg);
            return null;
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to read message [msg=" + msg + ", buf=" + buf + ", ses=" + ses + "]", e);
            throw e;
        }
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ClientListenerNioMessageParser.class.getSimpleName();
    }
}

