/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.performancestatistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class OperationType
extends Enum<OperationType> {
    public static final /* enum */ OperationType CACHE_GET = new OperationType(0);
    public static final /* enum */ OperationType CACHE_PUT = new OperationType(1);
    public static final /* enum */ OperationType CACHE_REMOVE = new OperationType(2);
    public static final /* enum */ OperationType CACHE_GET_AND_PUT = new OperationType(3);
    public static final /* enum */ OperationType CACHE_GET_AND_REMOVE = new OperationType(4);
    public static final /* enum */ OperationType CACHE_INVOKE = new OperationType(5);
    public static final /* enum */ OperationType CACHE_LOCK = new OperationType(6);
    public static final /* enum */ OperationType CACHE_GET_ALL = new OperationType(7);
    public static final /* enum */ OperationType CACHE_PUT_ALL = new OperationType(8);
    public static final /* enum */ OperationType CACHE_REMOVE_ALL = new OperationType(9);
    public static final /* enum */ OperationType CACHE_INVOKE_ALL = new OperationType(10);
    public static final /* enum */ OperationType TX_COMMIT = new OperationType(11);
    public static final /* enum */ OperationType TX_ROLLBACK = new OperationType(12);
    public static final /* enum */ OperationType QUERY = new OperationType(13);
    public static final /* enum */ OperationType QUERY_READS = new OperationType(14);
    public static final /* enum */ OperationType TASK = new OperationType(15);
    public static final /* enum */ OperationType JOB = new OperationType(16);
    public static final /* enum */ OperationType CACHE_START = new OperationType(17);
    public static final EnumSet<OperationType> CACHE_OPS;
    public static final EnumSet<OperationType> TX_OPS;
    private static final Map<Byte, OperationType> VALS;
    private final byte id;
    private static final /* synthetic */ OperationType[] $VALUES;

    public static OperationType[] values() {
        return (OperationType[])$VALUES.clone();
    }

    public static OperationType valueOf(String name) {
        return Enum.valueOf(OperationType.class, name);
    }

    private OperationType(int id) {
        this.id = (byte)id;
    }

    public byte id() {
        return this.id;
    }

    @Nullable
    public static OperationType of(byte id) {
        return VALS.get(id);
    }

    public static boolean cacheOperation(OperationType op) {
        return CACHE_OPS.contains((Object)op);
    }

    public static boolean transactionOperation(OperationType op) {
        return TX_OPS.contains((Object)op);
    }

    public static int cacheStartRecordSize(int nameLen, boolean cached) {
        return 5 + (cached ? 4 : 4 + nameLen);
    }

    public static int cacheRecordSize() {
        return 20;
    }

    public static int transactionRecordSize(int cachesIdsCnt) {
        return 4 + cachesIdsCnt * 4 + 8 + 8;
    }

    public static int queryRecordSize(int textLen, boolean cached) {
        return 1 + (cached ? 4 : 4 + textLen) + 1 + 8 + 8 + 8 + 1;
    }

    public static int queryReadsRecordSize() {
        return 41;
    }

    public static int taskRecordSize(int nameLen, boolean cached) {
        return 1 + (cached ? 4 : 4 + nameLen) + 24 + 8 + 8 + 4;
    }

    public static int jobRecordSize() {
        return 49;
    }

    static {
        $VALUES = new OperationType[]{CACHE_GET, CACHE_PUT, CACHE_REMOVE, CACHE_GET_AND_PUT, CACHE_GET_AND_REMOVE, CACHE_INVOKE, CACHE_LOCK, CACHE_GET_ALL, CACHE_PUT_ALL, CACHE_REMOVE_ALL, CACHE_INVOKE_ALL, TX_COMMIT, TX_ROLLBACK, QUERY, QUERY_READS, TASK, JOB, CACHE_START};
        CACHE_OPS = EnumSet.of(CACHE_GET, new OperationType[]{CACHE_PUT, CACHE_REMOVE, CACHE_GET_AND_PUT, CACHE_GET_AND_REMOVE, CACHE_INVOKE, CACHE_LOCK, CACHE_GET_ALL, CACHE_PUT_ALL, CACHE_REMOVE_ALL, CACHE_INVOKE_ALL});
        TX_OPS = EnumSet.of(TX_COMMIT, TX_ROLLBACK);
        HashMap<Byte, OperationType> vals = new HashMap<Byte, OperationType>();
        for (OperationType op : OperationType.values()) {
            OperationType old = vals.put(op.id(), op);
            assert (old == null) : "Duplicate operation ID found [op=" + (Object)((Object)op) + ']';
        }
        VALS = Collections.unmodifiableMap(vals);
    }
}

