/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParameter;
import org.apache.ignite.spi.IgniteSpiManagementMBean;
import org.apache.ignite.spi.discovery.DiscoverySpiMBean;
import org.jetbrains.annotations.Nullable;

@MXBeanDescription(value="MBean provide access to TCP-based discovery SPI.")
public interface TcpDiscoverySpiMBean
extends IgniteSpiManagementMBean,
DiscoverySpiMBean {
    @Override
    @MXBeanDescription(value="SPI state.")
    public String getSpiState();

    @MXBeanDescription(value="IP Finder.")
    public String getIpFinderFormatted();

    @MXBeanDescription(value="Reconnect count.")
    public int getReconnectCount();

    @MXBeanDescription(value="Connection check interval.")
    public long getConnectionCheckInterval();

    @MXBeanDescription(value="Network timeout.")
    public long getNetworkTimeout();

    @MXBeanDescription(value="Local TCP port.")
    public int getLocalPort();

    @MXBeanDescription(value="Local TCP port range.")
    public int getLocalPortRange();

    @MXBeanDescription(value="Threads priority.")
    public int getThreadPriority();

    @MXBeanDescription(value="IP finder clean frequency.")
    public long getIpFinderCleanFrequency();

    @MXBeanDescription(value="Statistics print frequency.")
    public long getStatisticsPrintFrequency();

    @MXBeanDescription(value="Message worker queue current size.")
    public int getMessageWorkerQueueSize();

    @Override
    @MXBeanDescription(value="Nodes joined count.")
    public long getNodesJoined();

    @Override
    @MXBeanDescription(value="Nodes left count.")
    public long getNodesLeft();

    @Override
    @MXBeanDescription(value="Nodes failed count.")
    public long getNodesFailed();

    @MXBeanDescription(value="Pending messages registered.")
    public long getPendingMessagesRegistered();

    @MXBeanDescription(value="Pending messages discarded.")
    public long getPendingMessagesDiscarded();

    @MXBeanDescription(value="Avg message processing time.")
    public long getAvgMessageProcessingTime();

    @MXBeanDescription(value="Max message processing time.")
    public long getMaxMessageProcessingTime();

    @MXBeanDescription(value="Total received messages count.")
    public int getTotalReceivedMessages();

    @MXBeanDescription(value="Received messages by type.")
    public Map<String, Integer> getReceivedMessages();

    @MXBeanDescription(value="Total processed messages count.")
    public int getTotalProcessedMessages();

    @MXBeanDescription(value="Processed messages by type.")
    public Map<String, Integer> getProcessedMessages();

    @MXBeanDescription(value="Local node is coordinator since.")
    public long getCoordinatorSinceTimestamp();

    @Override
    @MXBeanDescription(value="Coordinator node ID.")
    @Nullable
    public UUID getCoordinator();

    @MXBeanDescription(value="Message acknowledgement timeout.")
    public long getAckTimeout();

    @MXBeanDescription(value="Maximum message acknowledgement timeout.")
    public long getMaxAckTimeout();

    @MXBeanDescription(value="Socket timeout.")
    public long getSocketTimeout();

    @MXBeanDescription(value="Join timeout.")
    public long getJoinTimeout();

    @MXBeanDescription(value="Dump debug info.")
    public void dumpDebugInfo();

    @MXBeanDescription(value="Client mode.")
    public boolean isClientMode() throws IllegalStateException;

    @MXBeanDescription(value="Check ring latency.")
    public void checkRingLatency(@MXBeanParameter(name="maxHops", description="Maximum hops for the message (3 * TOTAL_NODE_CNT is recommended).") int var1);

    @MXBeanDescription(value="Get current topology version.")
    public long getCurrentTopologyVersion();

    @MXBeanDescription(value="Dumps ring structure to log.")
    public void dumpRingStructure();
}

