/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class ClusterInfoHandler
implements IgnitePerformanceStatisticsHandler {
    private final ObjectNode res = Utils.MAPPER.createObjectNode();
    private final Set<UUID> nodesIds = new HashSet<UUID>();
    private final Map<Integer, String> cachesIds = new HashMap<Integer, String>();

    @Override
    public void cacheStart(UUID nodeId, int cacheId, String name) {
        this.nodesIds.add(nodeId);
        this.cachesIds.put(cacheId, name);
    }

    @Override
    public void cacheOperation(UUID nodeId, OperationType type, int cacheId, long startTime, long duration) {
        this.nodesIds.add(nodeId);
        this.cachesIds.putIfAbsent(cacheId, null);
    }

    @Override
    public void transaction(UUID nodeId, GridIntList cacheIds, long startTime, long duration, boolean commited) {
        this.nodesIds.add(nodeId);
        GridIntIterator iter = cacheIds.iterator();
        while (iter.hasNext()) {
            this.cachesIds.putIfAbsent(iter.next(), null);
        }
    }

    @Override
    public void query(UUID nodeId, GridCacheQueryType type, String text, long id, long startTime, long duration, boolean success) {
        this.nodesIds.add(nodeId);
    }

    @Override
    public void queryReads(UUID nodeId, GridCacheQueryType type, UUID queryNodeId, long id, long logicalReads, long physicalReads) {
        this.nodesIds.add(nodeId);
    }

    @Override
    public void task(UUID nodeId, IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
        this.nodesIds.add(nodeId);
    }

    @Override
    public void job(UUID nodeId, IgniteUuid sesId, long queuedTime, long startTime, long duration, boolean timedOut) {
        this.nodesIds.add(nodeId);
    }

    @Override
    public Map<String, JsonNode> results() {
        ArrayNode nodes = Utils.MAPPER.createArrayNode();
        this.nodesIds.forEach(uuid -> {
            ObjectNode node = Utils.MAPPER.createObjectNode();
            node.put("id", uuid.toString());
            nodes.add((JsonNode)node);
        });
        ArrayNode caches = Utils.MAPPER.createArrayNode();
        this.cachesIds.forEach((id, name) -> {
            ObjectNode cache = Utils.MAPPER.createObjectNode();
            cache.put("id", id);
            cache.put("name", name);
            caches.add((JsonNode)cache);
        });
        this.res.set("nodes", (JsonNode)nodes);
        this.res.set("caches", (JsonNode)caches);
        return U.map((Object)"clusterInfo", (Object)this.res);
    }
}

