/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.performancestatistics.handlers.CacheOperationsHandler;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.internal.U;

public class TransactionsHandler
implements IgnitePerformanceStatisticsHandler {
    private static final String TOTAL = "total";
    public static final long[] HISTOGRAM_BUCKETS = new long[]{1L, 10L, 100L, 250L, 1000L};
    private final Map<UUID, Map<Integer, Map<TransactionState, Map<Long, CacheOperationsHandler.IntWrapper>>>> res = new HashMap<UUID, Map<Integer, Map<TransactionState, Map<Long, CacheOperationsHandler.IntWrapper>>>>();
    private final Map<UUID, Map<Integer, HistogramMetricImpl>> histogram = new HashMap<UUID, Map<Integer, HistogramMetricImpl>>();

    @Override
    public void transaction(UUID nodeId, GridIntList cacheIds, long startTime, long duration, boolean commited) {
        ArrayList<Integer> cacheIdsArr = new ArrayList<Integer>(cacheIds.size() + 1);
        cacheIdsArr.add(0);
        GridIntIterator iter = cacheIds.iterator();
        while (iter.hasNext()) {
            cacheIdsArr.add(iter.next());
        }
        UUID[] nodesId = new UUID[]{null, nodeId};
        long aggrTime = startTime / 1000L * 1000L;
        for (UUID node : nodesId) {
            for (Integer cacheId : cacheIdsArr) {
                ++this.res.computeIfAbsent((UUID)node, (Function<UUID, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$transaction$0(java.util.UUID ), (Ljava/util/UUID;)Ljava/util/Map;)()).computeIfAbsent(cacheId, (Function<Integer, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$transaction$1(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/util/Map;)()).computeIfAbsent(commited ? TransactionState.COMMIT : TransactionState.ROLLBACK, (Function<TransactionState, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$transaction$2(org.apache.ignite.internal.performancestatistics.handlers.TransactionsHandler$TransactionState ), (Lorg/apache/ignite/internal/performancestatistics/handlers/TransactionsHandler$TransactionState;)Ljava/util/Map;)()).computeIfAbsent(Long.valueOf((long)aggrTime), (Function<Long, CacheOperationsHandler.IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$transaction$3(java.lang.Long ), (Ljava/lang/Long;)Lorg/apache/ignite/internal/performancestatistics/handlers/CacheOperationsHandler$IntWrapper;)()).count;
                this.histogram.computeIfAbsent(node, uuid -> new HashMap()).computeIfAbsent(cacheId, id -> new HistogramMetricImpl(id.toString(), null, HISTOGRAM_BUCKETS)).value(U.nanosToMillis((long)duration));
            }
        }
    }

    @Override
    public Map<String, JsonNode> results() {
        ObjectNode jsonRes = this.resultsToJson();
        ObjectNode histogram = this.histogramToJson();
        ArrayNode buckets = Utils.MAPPER.createArrayNode();
        Arrays.stream(HISTOGRAM_BUCKETS).forEach(arg_0 -> ((ArrayNode)buckets).add(arg_0));
        return U.map((Object)"tx", (Object)jsonRes, (Object)"txHistogram", (Object)histogram, (Object)"txHistogramBuckets", (Object)buckets);
    }

    private ObjectNode resultsToJson() {
        ObjectNode json = Utils.MAPPER.createObjectNode();
        this.res.forEach((nodeId, cachesMap) -> {
            ObjectNode nodesInfo = Utils.createObjectIfAbsent(nodeId == null ? TOTAL : String.valueOf(nodeId), json);
            cachesMap.forEach((cacheId, opsMap) -> {
                ObjectNode cachesInfo = Utils.createObjectIfAbsent(cacheId == 0 ? TOTAL : String.valueOf(cacheId), nodesInfo);
                opsMap.forEach((opType, timingMap) -> {
                    ArrayNode op = Utils.createArrayIfAbsent(opType.name().toLowerCase(), cachesInfo);
                    timingMap.forEach((time, count) -> {
                        ArrayNode arr = Utils.MAPPER.createArrayNode();
                        arr.add(time);
                        arr.add(count.count);
                        op.add((JsonNode)arr);
                    });
                });
            });
        });
        return json;
    }

    private ObjectNode histogramToJson() {
        ObjectNode json = Utils.MAPPER.createObjectNode();
        this.histogram.forEach((nodeId, map) -> {
            ObjectNode nodesInfo = Utils.createObjectIfAbsent(nodeId == null ? TOTAL : String.valueOf(nodeId), json);
            map.forEach((cacheId, metric) -> {
                ArrayNode values = Utils.createArrayIfAbsent(cacheId == 0 ? TOTAL : String.valueOf(cacheId), nodesInfo);
                Arrays.stream(metric.value()).forEach(arg_0 -> ((ArrayNode)values).add(arg_0));
            });
        });
        return json;
    }

    private static /* synthetic */ CacheOperationsHandler.IntWrapper lambda$transaction$3(Long time) {
        return new CacheOperationsHandler.IntWrapper();
    }

    private static /* synthetic */ Map lambda$transaction$2(TransactionState state) {
        return new HashMap();
    }

    private static /* synthetic */ Map lambda$transaction$1(Integer id) {
        return new EnumMap(TransactionState.class);
    }

    private static /* synthetic */ Map lambda$transaction$0(UUID uuid) {
        return new HashMap();
    }

    static enum TransactionState {
        COMMIT,
        ROLLBACK;

    }
}

