/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.transform.statement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.pipe.receiver.transform.converter.ArrayConverter;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConvertedInsertTabletStatement
extends InsertTabletStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConvertedInsertTabletStatement.class);

    public PipeConvertedInsertTabletStatement(InsertTabletStatement insertTabletStatement, boolean isCopyMeasurement) {
        this.isDebug = insertTabletStatement.isDebug();
        this.devicePath = insertTabletStatement.getDevicePath();
        this.isAligned = insertTabletStatement.isAligned();
        this.times = insertTabletStatement.getTimes();
        this.bitMaps = insertTabletStatement.getBitMaps();
        this.columns = insertTabletStatement.getColumns();
        this.rowCount = insertTabletStatement.getRowCount();
        if (isCopyMeasurement) {
            Map<Integer, InsertBaseStatement.FailedMeasurementInfo> failedMeasurementIndex2Info;
            TSDataType[] dataTypes;
            String[] measurements;
            MeasurementSchema[] measurementSchemas = insertTabletStatement.getMeasurementSchemas();
            if (measurementSchemas != null) {
                this.measurementSchemas = Arrays.copyOf(measurementSchemas, measurementSchemas.length);
            }
            if ((measurements = insertTabletStatement.getMeasurements()) != null) {
                this.measurements = Arrays.copyOf(measurements, measurements.length);
            }
            if ((dataTypes = insertTabletStatement.getDataTypes()) != null) {
                this.dataTypes = Arrays.copyOf(dataTypes, dataTypes.length);
            }
            if ((failedMeasurementIndex2Info = insertTabletStatement.getFailedMeasurementInfoMap()) != null) {
                this.failedMeasurementIndex2Info = new HashMap<Integer, InsertBaseStatement.FailedMeasurementInfo>(failedMeasurementIndex2Info);
            }
        } else {
            this.measurementSchemas = insertTabletStatement.getMeasurementSchemas();
            this.measurements = insertTabletStatement.getMeasurements();
            this.dataTypes = insertTabletStatement.getDataTypes();
            this.failedMeasurementIndex2Info = insertTabletStatement.getFailedMeasurementInfoMap();
        }
        this.removeAllFailedMeasurementMarks();
    }

    public PipeConvertedInsertTabletStatement(InsertTabletStatement insertTabletStatement) {
        this(insertTabletStatement, true);
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        LOGGER.info("Pipe: Inserting tablet to {}.{}. Casting type from {} to {}.", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
        this.columns[columnIndex] = ArrayConverter.convert(this.dataTypes[columnIndex], dataType, this.columns[columnIndex]);
        this.dataTypes[columnIndex] = dataType;
        return true;
    }

    protected boolean originalCheckAndCastDataType(int columnIndex, TSDataType dataType) {
        return super.checkAndCastDataType(columnIndex, dataType);
    }
}

