/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.exception.CpuNotEnoughException;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.queryengine.statistics.StatisticsMergeUtil;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.iotdb.mpp.rpc.thrift.TOperatorStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceExecution.class);
    private final FragmentInstanceId instanceId;
    private final FragmentInstanceContext context;
    private List<IDriver> drivers;
    private ISink sink;
    private final FragmentInstanceStateMachine stateMachine;
    private final long timeoutInMs;
    private final MPPDataExchangeManager exchangeManager;
    private final ReadWriteLock statisticsLock = new ReentrantReadWriteLock();
    private boolean staticsRemoved = false;

    public static FragmentInstanceExecution createFragmentInstanceExecution(IDriverScheduler scheduler, FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sinkHandle, FragmentInstanceStateMachine stateMachine, long timeOut, boolean isExplainAnalyze, MPPDataExchangeManager exchangeManager) throws CpuNotEnoughException, MemoryNotEnoughException {
        FragmentInstanceExecution execution = new FragmentInstanceExecution(instanceId, context, drivers, sinkHandle, stateMachine, timeOut, exchangeManager);
        execution.initialize(scheduler, isExplainAnalyze);
        scheduler.submitDrivers(instanceId.getQueryId(), drivers, timeOut, context.getSessionInfo());
        return execution;
    }

    private FragmentInstanceExecution(FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sink, FragmentInstanceStateMachine stateMachine, long timeoutInMs, MPPDataExchangeManager exchangeManager) {
        this.instanceId = instanceId;
        this.context = context;
        this.drivers = drivers;
        this.sink = sink;
        this.stateMachine = stateMachine;
        this.timeoutInMs = timeoutInMs;
        this.exchangeManager = exchangeManager;
    }

    public FragmentInstanceState getInstanceState() {
        return this.stateMachine.getState();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return this.context.getErrorCode().map(s -> new FragmentInstanceInfo(this.stateMachine.getState(), this.context.getEndTime(), this.context.getFailedCause(), this.context.getFailureInfoList(), (TSStatus)s)).orElseGet(() -> new FragmentInstanceInfo(this.stateMachine.getState(), this.context.getEndTime(), this.context.getFailedCause(), this.context.getFailureInfoList()));
    }

    public long getStartTime() {
        return this.context.getStartTime();
    }

    public long getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public FragmentInstanceContext getFragmentInstanceContext() {
        return this.context;
    }

    public List<IDriver> getDrivers() {
        return this.drivers;
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    private boolean fillFragmentInstanceStatistics(FragmentInstanceContext context, TFetchFragmentInstanceStatisticsResp statistics) {
        statistics.setFragmentInstanceId(context.getId().toThrift());
        statistics.setQueryStatistics(context.getQueryStatistics().toThrift());
        statistics.setState(this.getInstanceState().toString());
        IDataRegionForQuery dataRegionForQuery = context.getDataRegion();
        if (dataRegionForQuery instanceof VirtualDataRegion) {
            return false;
        }
        statistics.setDataRegion(((DataRegion)context.getDataRegion()).getDataRegionId());
        statistics.setIp(IoTDBDescriptor.getInstance().getConfig().getAddressAndPort().ip);
        statistics.setStartTimeInMS(context.getStartTime());
        statistics.setEndTimeInMS(context.isEndTimeUpdate() ? context.getEndTime() : System.currentTimeMillis());
        statistics.setBlockQueuedTime(context.getBlockQueueTime());
        statistics.setReadyQueuedTime(context.getReadyQueueTime());
        statistics.setInitDataQuerySourceCost(context.getInitQueryDataSourceCost());
        statistics.setSeqClosednNum(context.getClosedSeqFileNum());
        statistics.setSeqUnclosedNum(context.getUnclosedSeqFileNum());
        statistics.setUnseqClosedNum(context.getClosedUnseqFileNum());
        statistics.setUnseqUnclosedNum(context.getUnclosedUnseqFileNum());
        return true;
    }

    private boolean fillFragmentInstanceStatistics(List<OperatorContext> contexts, Map<String, TOperatorStatistics> operatorStatisticsMap, Map<String, Integer> operatorCoutMap, Map<String, String> leadOverloadOperators, boolean needMerge) {
        for (OperatorContext operatorContext : contexts) {
            TOperatorStatistics operatorStatistics = new TOperatorStatistics();
            if (operatorContext.getPlanNodeId() == null) continue;
            String operatorType = operatorContext.getOperatorType();
            if (needMerge) {
                this.setOperatorStatistics(operatorStatistics, operatorContext);
                if (leadOverloadOperators.containsKey(operatorType)) {
                    StatisticsMergeUtil.merge(operatorStatisticsMap.get(leadOverloadOperators.get(operatorType)), operatorStatistics);
                    continue;
                }
                String planNodeId = operatorContext.getPlanNodeId().toString();
                operatorStatistics.setCount(1L);
                operatorStatistics.getSpecifiedInfo().clear();
                leadOverloadOperators.put(operatorType, planNodeId);
                operatorStatisticsMap.put(planNodeId, operatorStatistics);
                continue;
            }
            this.setOperatorStatistics(operatorStatistics, operatorContext);
            operatorStatisticsMap.put(operatorContext.getPlanNodeId().toString(), operatorStatistics);
            operatorCoutMap.put(operatorType, operatorCoutMap.getOrDefault(operatorType, 0) + 1);
            if (operatorCoutMap.get(operatorType) < IoTDBDescriptor.getInstance().getConfig().getMergeThresholdOfExplainAnalyze()) continue;
            needMerge = true;
            StatisticsMergeUtil.mergeAllOperatorStatistics(operatorStatisticsMap, leadOverloadOperators);
        }
        return needMerge;
    }

    private void setOperatorStatistics(TOperatorStatistics operatorStatistics, OperatorContext operatorContext) {
        operatorStatistics.setPlanNodeId(operatorContext.getPlanNodeId().toString());
        operatorStatistics.setOperatorType(operatorContext.getOperatorType());
        operatorStatistics.setTotalExecutionTimeInNanos(operatorContext.getTotalExecutionTimeInNanos());
        operatorStatistics.setNextCalledCount(operatorContext.getNextCalledCount());
        operatorStatistics.setHasNextCalledCount(operatorContext.getHasNextCalledCount());
        operatorStatistics.setOutputRows(operatorContext.getOutputRows());
        operatorStatistics.setSpecifiedInfo(operatorContext.getSpecifiedInfo());
        operatorStatistics.setMemoryUsage(operatorContext.getEstimatedMemorySize());
    }

    public TFetchFragmentInstanceStatisticsResp buildStatistics() {
        TFetchFragmentInstanceStatisticsResp statistics = new TFetchFragmentInstanceStatisticsResp();
        boolean res = this.fillFragmentInstanceStatistics(this.context, statistics);
        if (!res) {
            return statistics;
        }
        HashMap<String, TOperatorStatistics> operatorStatisticsMap = new HashMap<String, TOperatorStatistics>();
        HashMap<String, Integer> operatorCountMap = new HashMap<String, Integer>();
        HashMap<String, String> leadOverloadOperators = new HashMap<String, String>();
        boolean merge = false;
        for (IDriver driver : this.drivers) {
            merge = this.fillFragmentInstanceStatistics(driver.getDriverContext().getOperatorContexts(), operatorStatisticsMap, operatorCountMap, leadOverloadOperators, merge);
        }
        if (merge) {
            HashMap<String, TOperatorStatistics> newOperatorStatisticsMap = new HashMap<String, TOperatorStatistics>();
            for (Map.Entry entry : leadOverloadOperators.entrySet()) {
                newOperatorStatisticsMap.put((String)entry.getValue(), (TOperatorStatistics)operatorStatisticsMap.get(entry.getValue()));
            }
            statistics.setOperatorStatisticsMap(newOperatorStatisticsMap);
        } else {
            statistics.setOperatorStatisticsMap(operatorStatisticsMap);
        }
        StatisticsMergeUtil.mergeOperatorStatisticsIfDuplicate(statistics.getOperatorStatisticsMap());
        return statistics;
    }

    private void initialize(IDriverScheduler scheduler, boolean isExplainAnalyze) {
        this.stateMachine.addStateChangeListener(newState -> {
            try (SetThreadName threadName = new SetThreadName(this.instanceId.getFullId());){
                if (!newState.isDone()) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Enter the stateChangeListener");
                }
                this.statisticsLock.writeLock().lock();
                if (isExplainAnalyze) {
                    this.context.setFragmentInstanceStatistics(this.buildStatistics());
                }
                this.staticsRemoved = true;
                this.statisticsLock.writeLock().unlock();
                this.clearShuffleSinkHandle((FragmentInstanceState)((Object)newState));
                this.deleteTmpFile();
                for (IDriver driver : this.drivers) {
                    driver.close();
                }
                this.drivers = null;
                this.context.releaseResourceWhenAllDriversAreClosed();
                this.exchangeManager.deRegisterFragmentInstanceFromMemoryPool(this.instanceId.getQueryId().getId(), this.instanceId.getFragmentInstanceId(), true);
                this.context.releaseMemoryReservationManager();
                if (newState.isFailed()) {
                    scheduler.abortFragmentInstance(this.instanceId);
                }
            }
            catch (Throwable t) {
                try (SetThreadName threadName2 = new SetThreadName(this.instanceId.getFullId());){
                    LOGGER.error("Errors occurred while attempting to finish the FI process, potentially leading to resource leakage.", t);
                }
            }
        });
    }

    private void clearShuffleSinkHandle(FragmentInstanceState newState) {
        if (newState.isFailed()) {
            this.sink.abort();
        } else {
            this.sink.close();
        }
        this.sink = null;
    }

    private void deleteTmpFile() {
        String tmpFilePath;
        File tmpFile;
        if (this.context.mayHaveTmpFile() && (tmpFile = new File(tmpFilePath = IoTDBDescriptor.getInstance().getConfig().getSortTmpDir() + File.separator + this.context.getId().getFullId() + File.separator)).exists()) {
            FileUtils.deleteFileOrDirectory((File)tmpFile, (boolean)true);
        }
    }

    public boolean isStaticsRemoved() {
        return this.staticsRemoved;
    }

    public void lockStatistics() {
        this.statisticsLock.readLock().lock();
    }

    public void unlockStatistics() {
        this.statisticsLock.readLock().unlock();
    }
}

