/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class RemoveDataNodeStatement
extends Statement
implements IConfigStatement {
    final Set<Integer> nodeIds;

    public RemoveDataNodeStatement(List<Integer> dataNodeIDs) {
        this.nodeIds = new HashSet<Integer>(dataNodeIDs);
    }

    public Set<Integer> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitRemoveDataNode(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }
}

